@extends('admin/layouts.app')

@section('title', 'Manage Customers')

@section('content')

 <!-- Page content-->
        <div class="container-fluid">
          <div class="content-wrapper" id="dashboard">
            <div class="row">
                <div class="col-12">
                  <div class="header">
                    <div class="d-block d-sm-flex align-items-center justify-content-between">
                      <p class="fs-18 mb-0 d-flex align-items-center bg-transparent titlebrown">
                        <span class="menu-icons">
            <svg id="fi_9454038" enable-background="new 0 0 512 512" width="24" height="25" viewBox="0 0 512 512" width="512" xmlns="http://www.w3.org/2000/svg"><path d="m402.404 248.614c-16.437-25.669-35.331-45.405-55.106-58.136 8.175-6.394 13.444-16.335 13.444-27.489 0-12.955-7.105-24.275-17.622-30.297l44.574-86.492-4.778-6.062c-35.33-44.833-66.707-32.679-91.922-22.911-11.718 4.539-22.787 8.827-33.977 7.866l-1.026-.088-1.026.088c-11.226.964-21.833-3.357-33.068-7.931-23.857-9.711-53.547-21.798-88.83 22.976l-4.597 5.833 40.824 86.472c-10.755 5.957-18.055 17.414-18.055 30.546 0 11.154 5.27 21.095 13.445 27.489-19.772 12.73-38.663 32.464-55.095 58.129-27.768 43.367-44.346 96.657-44.346 142.55 0 32.279 8.345 59.556 24.132 78.883 18.408 22.534 45.694 33.96 81.101 33.96h171.058c35.403 0 62.687-11.424 81.093-33.954 15.787-19.324 24.131-46.598 24.131-78.872-.001-45.895-16.582-99.188-44.354-142.56zm-189.557-209.224c12.491 5.084 26.612 10.835 43.145 9.693 16.317 1.122 30.831-4.503 43.672-9.478 22.465-8.703 37.83-14.652 59.511 9.546l-40.68 78.935h-124.719l-37.171-78.736c21.304-24.179 34.811-18.685 56.242-9.96zm-26.676 134.503c-6.029 0-10.934-4.891-10.934-10.904 0-5.91 5.007-10.904 10.934-10.904h139.639c5.926 0 10.933 4.994 10.933 10.904 0 6.013-4.904 10.904-10.933 10.904h-29.887-79.866zm217.87 280.969c-13.627 16.68-34.657 25.138-62.507 25.138h-171.058c-67.14 0-81.233-48.314-81.233-88.844 0-40.875 15.541-90.538 40.557-129.609 25.903-40.454 57.342-63.655 86.258-63.655h79.866c64.127 0 126.834 110.674 126.834 193.281 0 26.678-6.473 48.701-18.717 63.689zm-171.217-139.684c0 12.261 5.152 14.98 25.626 19.283 17.802 3.742 44.705 9.396 44.705 42.794 0 19.949-14.952 36.766-35.165 41.623v21.929h-23.999v-21.929c-20.214-4.856-35.166-21.674-35.166-41.623h23.999c0 10.499 10.393 19.04 23.167 19.04 12.773 0 23.166-8.541 23.166-19.04 0-12.28-5.155-15.002-25.642-19.308-17.796-3.74-44.689-9.393-44.689-42.77 0-19.948 14.952-36.766 35.166-41.622v-21.929h23.999v21.929c20.213 4.856 35.165 21.674 35.165 41.622h-23.999c0-10.498-10.393-19.039-23.166-19.039-12.774.001-23.167 8.542-23.167 19.04z"></path></svg>
          </span>
                        <span class="mt-1 ms-2">Transactions Management</span>
                      </p>
                    </div>
                  </div>
                </div>
              </div>

            <div class="row pt-4">
                
              <div class="col-lg-12 position-relative">
                <ul class="nav nav-tabs" id="myTab" role="tablist">
                    <li class="nav-item" role="presentation">
                      <button class="nav-link active" id="home-tab" data-bs-toggle="tab" data-bs-target="#home" type="button" role="tab" aria-controls="home" aria-selected="true">Transaction History</button>
                    </li>
                    <li class="nav-item" role="presentation">
                      <button class="nav-link" id="profile-tab" data-bs-toggle="tab" data-bs-target="#profile" type="button" role="tab" aria-controls="profile" aria-selected="false">Refunds </button>
                    </li>
                  
                  </ul>
                  <div class="tab-content" id="myTabContent">
                    <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
                        <div class="border-0">
                            <div class="filter-box">
                                <div class="filter-block">
                                    <label for="inputEmail3" class="col-form-label">Start date </label>
                                    <div>
                                      <input type="date" class="form-control">
                                    </div>
                                  </div> 
                                  <div class="filter-block">
                                    <label for="inputEmail3" class="col-form-label">End date </label>
                                    <div>
                                      <input type="date" class="form-control">
                                    </div>
                                  </div>   
                            </div>
                         
                            <div class="card global-shadow p-4 w-100 table-responsive">
                                <table class="isplay w-100" id="upcomingReservation">
                                    <thead>
                                        <tr>
                                            <th scope="col">Booking ID</th>
                                            <th scope="col">Booking Date</th>
                                            <th scope="col">Rider name</th>
                                            <th scope="col">Driver Name</th>
                                            <th scope="col">Amount </th>
                                            <th scope="col">Platform Charge</th>
                                            <th scope="col">Purpose</th>
                                            <th scope="col">Status</th>
                                            <th scope="col">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                          @foreach($transactions as $transaction)
                                        <tr>
                                              <td>{{ $transaction->booking ? $transaction->booking->booking_id : '' }}</td>
                                              <td>{{ \Carbon\Carbon::parse($transaction->created_at)->format('jS F Y') }}</td>
                                              <td>{{ $transaction->rider ? $transaction->rider->first_name : '' }} {{ $transaction->rider ? $transaction->rider->last_name : '' }}</td>
                                              <td>{{ $transaction->driver ? $transaction->driver->first_name : '' }} {{ $transaction->driver ? $transaction->driver->last_name : '' }}</td>
                                              <td>${{$transaction->amount ? $transaction->amount : 0}}.00</td>
                                              <td>${{$transaction->platform_fee ? $transaction->platform_fee : 0}}.00</td>
                                              
                                               <td>   @if(!empty($transaction->purpose))
                                                        @php
                                                            $words = explode('_', $transaction->purpose);
                                                            $formattedPurpose = implode(' ', array_map('ucwords', $words));
                                                        @endphp
                                                        {{ $formattedPurpose }}
                                                    @endif
                                                </td>
                                             <td>
                                                @if($transaction->status == 0)
                                                    @php
                                                        $buttonClass = 'btnyellow';
                                                        $status = 'Pending';
                                                    @endphp
                                                @elseif($transaction->status == 1)
                                                    @php
                                                        $buttonClass = 'btn-danger';
                                                        $status = 'Failed';
                                                    @endphp
                                                @elseif($transaction->status == 2)
                                                    @php
                                                        $buttonClass = 'btnyellow';
                                                        $status = 'On Hold';
                                                    @endphp
                                                @elseif($transaction->status == 3)
                                                    @php
                                                        $buttonClass = 'btngreen';
                                                        $status = 'Success';
                                                    @endphp
                                                @else
                                                    @php
                                                        $buttonClass = 'btn-secondary';
                                                        $status = 'Unknown';
                                                    @endphp
                                                @endif
                                            
                                                <span class="badge {{ $buttonClass }} p-2 fs-12">{{ $status }}</span>
                                            </td>

                                               <td><a role="button" class="btn btnRed" href="javascript:;" data-bs-toggle="modal" data-bs-target="#exampleModal">View Detail</a> </td>
                                          </tr>
                                        @endforeach
                                          <!--<tr>-->
                                          <!--  <td>5 jun 2020</td>-->
                                          <!--    <td>Armor Sios</td>-->
                                          <!--    <td>Cody Fisher</td>-->
                                          <!--    <td>$35.00</td>-->
                                          <!--     <td><span class="badge btn-danger p-2 fs-12">Failed</span></td> -->
                                          <!--     <td><a role="button" class="btn btnRed" href="javascript:;" data-bs-toggle="modal" data-bs-target="#exampleModal">View Detail</a> </td>-->
                                          <!--</tr>-->
                                      
        
                                          <!--<tr>-->
                                          <!--  <td>5 jun 2020</td>-->
                                          <!--    <td>Armor Sios</td>-->
                                          <!--    <td>Cody Fisher</td>-->
                                          <!--    <td>$35.00</td>-->
                                          <!--     <td><span class="badge btnyellow btnyellow p-2 fs-12">Refunded </span></td> -->
                                          <!--     <td><a role="button" class="btn btnRed" href="javascript:;" data-bs-toggle="modal" data-bs-target="#exampleModal">View Detail</a> </td>-->
                                          <!--</tr>-->
                                         
                                    </tbody>
                                </table>
                            </div>
                          </div>
                    </div>
                    <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                      <div class="border-0">
                      <div class="card global-shadow p-4 w-100">
                        <table class="isplay w-100" id="upcomingReservation2">
                            <thead>
                                <tr>
                                    <th scope="col">Booking date</th>
                                    <th scope="col">Rider name</th>
                                    <th scope="col">Driver Name</th>
                                    <th scope="col">Amount </th>
                                    <th scope="col">Refund Reason</th>
                                    <th scope="col">Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>5 jun 2020</td>
                                      <td>Armor Sios</td>
                                      <td>Cody Fisher</td>
                                      <td>$35.00</td>
                                      <td>Driver didn't accepted booking
                                        Customer cancelled the ride</td>
                                       <td><span class="badge btngreen p-2 fs-12">Full refunded</span></td> 
                                  </tr>
                                  <tr>
                                    <td>5 jun 2020</td>
                                      <td>Armor Sios</td>
                                      <td>Cody Fisher</td>
                                      <td>$35.00</td>
                                      <td>Driver didn't accepted booking
                                        Customer cancelled the ride</td>
                                       <td><span class="badge btnyellow p-2 fs-12">Partial refunded</span></td> 
                                  </tr>      
                                  <tr>
                                    <td>5 jun 2020</td>
                                      <td>Armor Sios</td>
                                      <td>Cody Fisher</td>
                                      <td>$35.00</td>
                                      <td>Driver didn't accepted booking
                                        Customer cancelled the ride</td>
                                       <td><span class="badge btngreen p-2 fs-12">Full refunded</span></td> 
                                  </tr>
                                  <tr>
                                    <td>5 jun 2020</td>
                                      <td>Armor Sios</td>
                                      <td>Cody Fisher</td>
                                      <td>$35.00</td>
                                      <td>Driver didn't accepted booking
                                        Customer cancelled the ride</td>
                                       <td><span class="badge btnyellow p-2 fs-12">Partial refunded</span></td> 
                                  </tr>  
                            </tbody>
                        </table>
                    </div>
                  </div>
                    </div>
                  </div>
              
                </div>
              </div>
        </div>
      </div>
      
      <!-- Modal Transaction History -->
<div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Transaction Details</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
          <ol class="list-group">
              <li class="list-group-item d-flex justify-content-between align-items-start">
                <div class="ms-2 me-auto">
                  <div class="fw-bold">Booking Date</div>
                  5 jun 2020
                </div>
              </li>
              <li class="list-group-item d-flex justify-content-between align-items-start">
                <div class="ms-2 me-auto">
                  <div class="fw-bold">Rider name</div>
                  Armor Sios
                </div>
              </li>
              <li class="list-group-item d-flex justify-content-between align-items-start">
                <div class="ms-2 me-auto">
                  <div class="fw-bold">Driver Name  </div>
                  Cody Fisher
                </div>
              </li>
              <li class="list-group-item d-flex justify-content-between align-items-start">
                <div class="ms-2 me-auto">
                  <div class="fw-bold">Amount</div>
                  $35.00	
                </div>
              </li>
            </ol>

        </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        <button type="button" class="btn btnRed">Save</button>
      </div>
    </div>
  </div>
</div>

@endsection