<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Record Audio</title>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</head>
<body>
    <h1>Record Audio</h1>
    <button id="startRecording">Start Recording</button>
    <button id="stopRecording" disabled>Stop Recording</button>
    <audio id="audioPreview" controls style="display: none;"></audio>

<script>
    let mediaRecorder;
    let audioChunks = [];

    $(document).ready(function () {
        const startButton = $("#startRecording");
        const stopButton = $("#stopRecording");
        const audioPreview = $("#audioPreview");

        // Start Recording
        startButton.on("click", async function () {
            try {
                const stream = await navigator.mediaDevices.getUserMedia({ audio: true });
                mediaRecorder = new MediaRecorder(stream);

                mediaRecorder.ondataavailable = (event) => {
                    audioChunks.push(event.data);
                };

                mediaRecorder.onstop = () => {
                    const audioBlob = new Blob(audioChunks, { type: "audio/wav" }); // or 'audio/ogg' if preferred
                    audioChunks = [];

                    // Create an object URL for the audio blob
                    const audioUrl = URL.createObjectURL(audioBlob);
                    audioPreview.attr("src", audioUrl).show();

                    // Play the audio after recording
                    audioPreview[0].play().catch(error => {
                        console.error("Audio playback failed:", error);
                        alert("Failed to play the audio.");
                    });

                    uploadAudio(audioBlob); // Upload audio to server
                };

                mediaRecorder.start();
                startButton.prop("disabled", true);
                stopButton.prop("disabled", false);
            } catch (error) {
                console.error("Error accessing microphone:", error);
                alert("Microphone access is required to record voice notes.");
            }
        });

        // Stop Recording
        stopButton.on("click", function () {
            mediaRecorder.stop();
            startButton.prop("disabled", false);
            stopButton.prop("disabled", true);
        });

        // Upload Audio
        function uploadAudio(audioBlob) {
            const formData = new FormData();
            formData.append("audio", audioBlob, "voice_note.wav"); // You can also use 'voice_note.ogg' or another format

            $.ajax({
                url: "{{ route('audio.upload') }}", // Replace with your API route
                type: "POST",
                data: formData,
                processData: false,
                contentType: false,
                headers: {
                    "X-CSRF-TOKEN": "{{ csrf_token() }}"
                },
                success: function (response) {
                    alert("Audio uploaded successfully!");
                    console.log(response);
                },
                error: function (error) {
                    alert("Failed to upload audio.");
                    console.error(error);
                }
            });
        }
    });
</script>

</body>
</html>
