<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\UserController;
use App\Http\Controllers\Api\BookingController;
use App\Http\Controllers\Api\StripeController;
use App\Http\Controllers\Api\TestAuthController;
use App\Http\Controllers\Api\FaqController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::post('register',[AuthController::class,'register']);
Route::post('login', [AuthController::class,'login']);
Route::post('singpass-login',[AuthController::class,'singPassLogin']);

Route::post('/send/vpnmail', [AuthController::class, 'sendVpnMail']);
Route::post('auth/verify',[TestAuthController::class, 'handleSingpassCallback']);
Route::get('/auth/singpass-url', [TestAuthController::class, 'getSingpassAuthUrl']);
// FAQ Routes
Route::get('get-faq', [FaqController::class, "getFaq"]);

//Upload Files Handling
Route::post('upload-file',[UserController::class,'fileUpload']);
Route::post('delete-file',[UserController::class,'deleteUploadedFile']);


 

// Auth Routes
Route::middleware(['auth:api'])->group(function () {
    
    // Route::post('pages',[AuthController::class, 'pages']);
    Route::post('verify-otp', [AuthController::class,'verifyOtp']);
    Route::post('resend-otp', [AuthController::class,'resendOtp']);
    Route::post('contact-us', [AuthController::class,'contactUs']);
    Route::post('refresh', [AuthController::class,'refresh']);
    Route::post('logout', [AuthController::class,'logout']);    
    
    //Users Routes
    Route::post('update-singpass-profile',[UserController::class,'updateSingpassProfieDetail']);
    Route::get('profile', [UserController::class,'profieDetail']);
    Route::post('update-profile', [UserController::class,'updateProfieDetail']);
    Route::post('upload-driving-license', [UserController::class,'uploadDrivingLicense']);
    Route::post('upload-selfie', [UserController::class,'uploadSelfieWithLicense']);
    Route::post('upload-profile-picture', [UserController::class,'uploadProfilePic']);
    Route::post('delete-account', [UserController::class,'deleteAccount']);
    Route::post('update-current-location',[UserController::class,'updateCurrentLocation']);
    Route::get('notifications', [UserController::class,'getNotifications']);
    
    Route::post('driver-earnings',[UserController::class,'driverEarnings']);
    Route::post('earning-detail',[UserController::class,'driverEarningDetail']);
    
    
    //Booking Routes
    Route::get('get-unique-booking-id', [BookingController::class,'getUniqueBookingId']);
    Route::get('get-fare-list', [BookingController::class,'getFaresDetail']);
    Route::post('schedule-ride', [BookingController::class,'scheduleRide']);
    Route::post('delay-ride', [BookingController::class,'delayRide']);
    Route::post('cancel-ride', [BookingController::class,'cancelRide']);
    Route::post('accept-ride', [BookingController::class,'acceptRide']);
    Route::post('change-ride-status', [BookingController::class,'changeBookingStatus']);
    Route::post('delete-unpaid-bookings', [BookingController::class,'deleteUnpaidBookings']);
    
    // Booking Details
    Route::get('filter-bookings', [BookingController::class,'filterBookings']);
    Route::get('booking-history', [BookingController::class,'bookingHistory']);
    Route::get('current-bookings', [BookingController::class,'currentBookings']);
    Route::get('upcoming-bookings', [BookingController::class,'upComingBookings']);
    Route::get('completed-bookings', [BookingController::class,'completedBookings']);
    Route::get('available-rides', [BookingController::class,'availableRideRequests']);
    Route::post('ride-detail', [BookingController::class,'getRideDetails'])->withoutMiddleware(['auth:api']);
    
   
    
    Route::post('add-bank', [StripeController::class,'addBank']);
    Route::get('create-checkout-session', [StripeController::class,'createCheckoutSession']);
    Route::post('make-payment', [StripeController::class,'makePayment']);
    Route::get('get-card-list', [StripeController::class,'getCardDetail']);
    Route::post('charge-payment', [StripeController::class,'charge']);
    Route::post('confirm-payment', [StripeController::class,'confirmPayment']);
    //testing purpose only 
    Route::post('test-payment', [StripeController::class,'testPayment']);
    
    
    
});
// End Auth Routes