<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Foundation\Auth\EmailVerificationRequest;
use App\Http\Controllers\Admin\AdminAuthController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\JWKController;
use App\Http\Controllers\AudioFileController;

Route::group(['prefix' => 'admin', 'namespace' => 'Admin'], function () {
    Route::get('/login', [AdminAuthController::class, 'getLogin'])->name('adminLogin');
    Route::post('/login', [AdminAuthController::class, 'postLogin'])->name('adminLoginPost');
    

    // forget password
    Route::get('/forgot/password', [AdminAuthController::class, 'showForgetPasswordForm'])->name('auth.forgotPassword');
    Route::post('/forgot/password', [AdminAuthController::class, 'submitForgetPasswordForm'])->name('auth.submitforgotPassword');
    Route::get('/reset/password/{token}', [AdminAuthController::class, 'showResetPasswordForm'])->name('auth.showresetPassword');
    Route::post('/reset/password', [AdminAuthController::class, 'submitResetPasswordForm'])->name('auth.submitresetPassword');
    
    Route::group(['middleware' => 'adminauth'], function () {
        Route::get('/', [DashboardController::class, 'index'] )->name('adminDashboard');
        Route::get('/customers', [DashboardController::class, 'manageCustomers'] )->name('manageCustomers');
        Route::get('/customers/delete/{id}', [DashboardController::class, 'deleteCustomer'] )->name('deleteCustomer');
        Route::get('/drivers', [DashboardController::class, 'manageDrivers'] )->name('manageDrivers');
        Route::get('/drivers/detail/{id}', [DashboardController::class, 'manageDriversDetail'] )->name('manageDriversDetail');
        Route::get('/drivers/delete/{id}', [DashboardController::class, 'deleteDriver'] )->name('deleteDriver');
        Route::get('/booking', [DashboardController::class, 'bookingMngt'] )->name('bookingMngt');
        Route::get('/booking/detail/{id}', [DashboardController::class, 'bookingDetail'] )->name('bookingDetail');
        Route::get('/chat', [DashboardController::class, 'chatView'] )->name('admin.booking.chat');
        Route::get('/transactions', [DashboardController::class, 'transactionMngt'] )->name('transactionMngt');
        Route::get('/faq', [DashboardController::class, 'faqMngt'] )->name('faqMngt');
        Route::post('add/faq', [DashboardController::class, 'addFaq'] )->name('addFaq');
        Route::post('/faq/edit', [DashboardController::class, 'editFaq'])->name('editFaq');
        Route::get('/faq/delete/{id}', [DashboardController::class, 'deleteFaq'] )->name('deleteFaq');
        Route::get('/queries', [DashboardController::class, 'queryMngt'] )->name('queryMngt');
        Route::post('/query/mail', [DashboardController::class, 'sendMailToUsers']);//->name('adminUserMail');
        Route::get('/fee', [DashboardController::class, 'feesMngt'] )->name('feesMngt');
        Route::post('/fee/edit', [DashboardController::class, 'editFee'])->name('editFee');
        Route::get('/password/index', [DashboardController::class, 'settingPassword'] )->name('settingPassword');
        Route::post('/change/password', [DashboardController::class, 'updatePassword'] )->name('updatePassword');
        Route::get('logout', [DashboardController::class, "adminLogout"]);
        
        Route::get('/admin/customers/activate/{id}', [DashboardController::class, 'activateCustomer'])->name('customer.activate');
        Route::get('/admin/customers/deactivate/{id}', [DashboardController::class, 'deactivateCustomer'])->name('customer.deactivate');
        
        Route::get('/admin/drivers/activate/{id}', [DashboardController::class, 'activateDriver'])->name('drivers.activate');
        Route::get('/admin/drivers/deactivate/{id}', [DashboardController::class, 'deactivateDriver'])->name('drivers.deactivate');
        
        
       Route::post('/unmatch/driver', [DashboardController::class, 'unmatchDriver']);
       Route::post('/delay-ride/store', [DashboardController::class, 'storeDelay'])->name('delay.ride.store');


    });
});


Route::get('/terms-and-conditions',[AdminAuthController::class, 'termsAndConditions']);
Route::get('/privacy-policy',[AdminAuthController::class, 'privacyPolicy']);

// Route::get('/.well-known/jwks.json', [JWKController::class, 'getJWK']);

// Route::get('/redirect', [JWKController::class, 'redirectToSingpass']);
// Route::get('/callback', [JWKController::class, 'handleSingpassCallback']);

//Not in use currently
// Route::get('/email/verify', function () {
//     return view('auth.verify-email');
// })->middleware('auth')->name('verification.notice');

// Route::get('/email/verify/{id}/{hash}', function (EmailVerificationRequest $request) {
//     $request->fulfill();
 
//     return redirect('/home');
// })->middleware(['auth', 'signed'])->name('verification.verify');

// Route::post('/email/verification-notification', function (Request $request) {
//     $request->user()->sendEmailVerificationNotification();
 
//     return back()->with('message', 'Verification link sent!');
// })->middleware(['auth', 'throttle:6,1'])->name('verification.send');