//https://socket.io/get-started/chat/

const express = require("express");
const app = express();
const fs = require('fs');
const https = require('https');
const socketIo = require('socket.io');

const options = {
  key: fs.readFileSync('/home/phpparastechnolo/ssl/keys/9d402_09b1d_657eeb02c36f0ed047c705bb99470bf0.key'),
  cert: fs.readFileSync('/home/phpparastechnolo/ssl/certs/php_parastechnologies_in_9d402_09b1d_1740788349_8730e99bbc00e3c765d814b82d6d2eb3.crt'),
  ca: fs.readFileSync('/home/phpparastechnolo/ssl/ca_bundle/custom_bundle.crt')
};


// Create HTTPS server
const server = https.createServer(options, app);
const io = require('socket.io')(server, {
    cors: {origin: '*'}
});

const port = 8072;

const socketController = require("./src/controllers/socketController.js");
socketController.handleSocketEvents(io);

// Error handling middleware
app.use((err, req, res, next) => {
  console.error(err.stack);
  res.status(500).send('Something broke!');
});

// Start the HTTPS server
server.listen(port, function () {
  console.log('Socket.io server is running over HTTPS on port %d', port);
});

module.exports = { app, server, io };