const service = require("../services/mysql.services");

const joinBookingRoom = async (socket, io, request) =>
{
    try
    {
         socket.join(request.roomName);
        //  console.log(request.roomName);
        data = await service.getBookingList(request);
         console.log(`Socket ${socket.id} joined room: ${request.roomName}`);
    }
    catch(e)
    {
        data = e.message
    }
    io.to(socket.id).emit("joinBookingRoom",  data);
}


const joinCurrentBookingsRoom = async (socket, io, request) =>
{
    try
    {
         socket.join(request.roomName);
         console.log(request.roomName);
         data = await service.getCurrentBookingList(request);
         console.log(`Socket ${socket.id} joined room: ${request.roomName}`);
    }
    catch(e)
    {
        data = e.message
    }
    io.emit("currentBookingsRoom"+request.rider_id,  data);
}

const leaveBookingRoom = async (socket, io, request) =>
{
    try
    {
         socket.leave(request.roomName);
          console.log(`Socket ${socket.id} left room: ${request.roomName}`);
    }
    catch(e)
    {
        data = e.message
          console.log("Catch",data)
    }
    
}

const scheduleBooking = async (socket, io, request) =>
{
    try
    {
         
        data = await service.scheduleBookingService(request);
        console.log(data, "sdfsjk");
        // socket.join(request.roomID);
    }
    catch(e)
    {
        data = e.message
        console.log(data, "jlsidjflks");
    }
    // io.to(request.roomName).emit('CreateBooking', data);
    io.emit('CreateBooking'+ request.rider_id , data);
    //io.emit("CreateBooking",  data);
}

const createdBookingPayment = async (socket, io, request) =>
{
    try
    {
         
        data = await service.createdBookingPaymentService(request);
        console.log(data, "sdfsjk");
        // socket.join(request.roomID);
    }
    catch(e)
    {
        data = e.message
        console.log(data, "jlsidjflks");
    }
    io.to(request.roomName).emit('NewBooking', data);
    io.emit('NewBooking'+ request.rider_id , data);
    //io.emit("CreateBooking",  data);
}

const acceptBooking = async (socket, io, request) =>
{
    try
    
    {
        console.log(request);
        data = await service.acceptBookingService(request);
        
        // availableBookings = await service.getBookingList(request);
        
        currentbookigList = await service.getCurrentBookingList(request);
        //   console.log(`Socket ${socket.id} left room: ${request.roomName}`);
    }
    catch(e)
    {
        data = e.message
          console.log("Catch",data)
    }
    //listner for rider side 
    io.emit("RiderAcceptBooking"+request.rider_id,  data);
    io.emit("DriverAcceptBooking"+request.driver_id,  data);
    //to remove the list from other drivers if accepted by someone
    io.emit("BookingAccepted");
    //listner for current booking list update
    io.emit("currentBookingsRoom"+request.rider_id,  currentbookigList);
}


const cancelBooking = async (socket, io, request) =>
{
    try
    {
        console.log(request, "cancel booking");
        data = await service.cancelBookingService(request);
        
        currentbookigList = await service.getCurrentBookingList(request);
    }
    catch(e)
    {
        data = e.message
          console.log("Catch",data)
    }
    //listner for rider side 
    io.emit("CancelBooking",  data);
    io.emit("CancelBooking"+request.booking_id,  data);
    //listner for current booking list update
    io.emit("currentBookingsRoom"+request.rider_id,  currentbookigList);
}

const rejectBooking = async (socket, io, request) =>
{
    try
    {
        console.log(request, "cancel booking");
        await service.rejectBookingService(request);
    }
    catch(e)
    {
        data = e.message
          console.log("Catch",data)
    }
    io.emit("BookingRejected"+request.driver_id);
}


const delayBooking = async (socket, io, request) =>
{
    try
    {
        console.log(request, "delay Booking");
        
        data = await service.delayBookingService(request);
        
        currentbookigList = await service.getCurrentBookingList(request);
        //   console.log(`Socket ${socket.id} left room: ${request.roomName}`);
    }
    catch(e)
    {
        data = e.message
          console.log("Catch",data)
    }
    //listner for rider side 
    io.emit("DelayBooking"+request.booking_id,  data);
    // io.emit("DriverAcceptBooking"+request.driver_id,  data);
    //listner for current booking list update
    io.emit("currentBookingsRoom"+request.rider_id,  currentbookigList);
}


const getBookingDetail = async (socket, io, request) =>
{
    try
    {
        console.log(request);
        data = await service.getBookingDetailService(request);
        //   console.log(`Socket ${socket.id} left room: ${request.roomName}`);
    }
    catch(e)
    {
        data = e.message
          console.log("Catch",data)
    }
    // io.to(socket.id).emit("AcceptBooking",  data);
    if(request.user_type === "1"){
     io.emit("BookingDetailRider"+ request.user_id,  data);    
    }
    if(request.user_type === "2"){
     io.emit("BookingDetailDriver"+ request.user_id,  data);    
    }
    
}



const updateBookingStatus = async (socket, io, request) =>
{
    try
    {
        console.log(request, "update Booking Status");
        data = await service.updateBookingStatusService(request);
        //   console.log(`Socket ${socket.id} left room: ${request.roomName}`);
    }
    catch(e)
    {
        data = e.message
          console.log("Catch",data)
    }
    // io.to(socket.id).emit("UpdatedBookingStaus",  data);
     io.emit('rider' + request.bookingID, data);
     io.emit('driver' + request.bookingID, data);
}


module.exports = {
    joinBookingRoom,leaveBookingRoom,scheduleBooking, createdBookingPayment,acceptBooking,updateBookingStatus,joinCurrentBookingsRoom,getBookingDetail,cancelBooking, delayBooking,
    rejectBooking
};