mysql = require('mysql');


const updateUserStatusOnline = async (token) => 
{
    return sqlQuery = "UPDATE users SET is_online = '1' WHERE chat_token = "+ '"'+token+'"';
}

const getUserByChatTokenQuery = async (token) => 
{
    return sqlQuery = "select id FROM users  WHERE chat_token ="+ '"'+token+'"';
}

const getUserQuery = async (id) => 
{
    return sqlQuery = "select * FROM users  WHERE chat_token ="+ '"'+id+'"';
}
// const getBookingsQuery = async (driverID) => 
// {
//     //  return `SELECT * FROM bookings WHERE bookings.status NOT IN (5, 6, 7);`;
//   return "SELECT bookings.*,DATE_FORMAT(bookings.created_at, '%Y-%m-%d %H:%i:%s') as created_at,DATE_FORMAT(bookings.updated_at, '%Y-%m-%d %H:%i:%s') as updated_at FROM bookings WHERE status IN (0, 1,2) AND (driver_id IS NULL OR driver_id = '" + driverID + "') order by id desc";
// }

const getBookingsQuery = async (driverID) => {
    return `
        SELECT 
            bookings.*, 
            DATE_FORMAT(bookings.created_at, '%Y-%m-%d %H:%i:%s') as created_at, 
            DATE_FORMAT(bookings.updated_at, '%Y-%m-%d %H:%i:%s') as updated_at
        FROM 
            bookings
        WHERE 
            status IN (0, 1, 2)
            AND
            is_paid = 1 
            AND (driver_id IS NULL OR driver_id = '${driverID}')
            AND NOT EXISTS (
                SELECT 1 
                FROM rejected_rides 
                WHERE rejected_rides.booking_id = bookings.id 
                  AND rejected_rides.driver_id = '${driverID}'
            )
        ORDER BY 
            id DESC
    `;
};


const getCurrentBookingsQuery = async (riderID) => 
{
    //  return `SELECT * FROM bookings WHERE bookings.status NOT IN (5, 6, 7);`;
   return "SELECT bookings.*,DATE_FORMAT(bookings.created_at, '%Y-%m-%d %H:%i:%s') as created_at,DATE_FORMAT(bookings.updated_at, '%Y-%m-%d %H:%i:%s') as updated_at FROM bookings WHERE NOT is_paid = 0 AND status NOT IN (3, 4,5) AND (rider_id = '" + riderID + "') order by id desc";
}


const getDriverUpcomingBookingCount = async (driverID) => 
{
   return "SELECT COUNT(*) as upcoming_booking_count FROM bookings WHERE driver_id = '" + driverID + "' AND status = 1 AND driver_status = 1";
}

const updateBookingStatusDriver = async (request) => 
{
    const driverStatus = request.status;
    if(driverStatus === "4"){
        const statusCompleted = 3;
         return "UPDATE bookings SET driver_status = " + request.status + ", status = " + statusCompleted + " WHERE booking_id = '" + request.bookingID + "'";
    }else{
        return "UPDATE bookings SET driver_status = " + request.status + " WHERE booking_id = '" + request.bookingID + "'";
    }
    
}

const getUserDetailByID = async (id) => 
{ 
    return "SELECT * FROM users WHERE id = '" + id + "'";
}

const getDrivers = async () => 
{ 
    const userType = 2;
    const isActive = 1;
    return query = `SELECT * FROM users WHERE user_type = '${userType}' AND status = '${isActive}'`;
}

const updateBookingStatusRider = async (request) => 
{
    return "UPDATE bookings SET rider_status = " + request.status + " WHERE booking_id = '" + request.bookingID + "'";
}

const updateUserActivityQuery = async (id) => 
{
    return "UPDATE users SET user_last_active = NOW() WHERE id = '" + id + "'";
}

const acceptBookingQuery = async (request) => {
    const bookingStatus = 1;

    return (
        "UPDATE bookings " +
        "SET driver_status = " + request.driver_status + 
        ", driver_id = '" + request.driver_id + "', " + 
        "status = " + bookingStatus + " " +
        "WHERE id = '" + request.booking_id + "'"
    );
};


const cancelBookingQuery = async (request) => {
    const statusCancel = 4; 
    const userType = request.user_type; 
    const cancelationFee = request.cancelationFee; 
    const cancelationFeeCut = request.cancelationFeeCut; 
    const bookingId = request.booking_id;

    return `
        UPDATE bookings 
        SET 
            status = ${statusCancel}, 
            canceled_at = NOW(), 
            canceled_by = ${userType} ,
            rider_cancelation_fee = ${cancelationFee},
            rider_cancelation_platform_fee = ${cancelationFeeCut}
        WHERE 
            id = '${bookingId}';
    `;
};

const rejectBookingQuery = async (request) => {
    const driverId = request.driver_id; 
    const bookingId = request.booking_id;

    return `
        INSERT INTO rejected_rides (driver_id, booking_id, created_at, updated_at) 
        VALUES (${driverId}, ${bookingId}, UTC_TIMESTAMP(), UTC_TIMESTAMP())
    `;
};


const delayBookingQuery = async (request) => {
  const statusDelayed = 2;
  const delayTime = request.delayTime;
  const bookingId = request.booking_id;
  const delayFee = request.delayFee;

  return query = `
    UPDATE bookings 
    SET 
        status = ${statusDelayed}, 
        rider_delay_time = rider_delay_time + ${delayTime}, 
        rider_delay_count = rider_delay_count + 1,rider_delay_fee = rider_delay_fee + ${delayFee},
        is_delayed = 1,
        delay_time = IFNULL(delay_time, pickup_time) + INTERVAL ${delayTime} MINUTE
    WHERE 
        id = '${bookingId}';
  `;
};



const getDropPointsQuery = async (bookingIds) => {
    // Generate a query to fetch all drop-off points for the given booking IDs
    const ids = bookingIds.join(", "); // Ensure IDs are joined in the format `1, 2, 3`
    return `SELECT * FROM drop_of_points WHERE booking_id IN (${ids});`;
};

const updateUserOffileStatusbyuserID = async (userID,status) => 
{
    return "UPDATE users set is_online = "+status+" WHERE  id = "+ '"'+userID+'"';    
}
const checkRoomQuery = async (roomID,userID) => 
{
    const roomID1 = mysql.escape(roomID);
    const userID1 = mysql.escape(userID);
    return `SELECT * FROM room WHERE joinID = ${userID1} AND roomID = ${roomID1} LIMIT 1;`;
};
const updateRoomStatus = async (roomID,userID) => 
{
    const roomID1 = mysql.escape(roomID);
    const userID1 = mysql.escape(userID);
    return `UPDATE room set status = 1  WHERE joinID = ${userID1} AND roomID = ${roomID1} `;
}

const leaveRoomStatus = async (roomID,userID) => 
{
    const roomID1 = mysql.escape(roomID);
    const userID1 = mysql.escape(userID);
    return `UPDATE room set status = 0  WHERE joinID = ${userID1} AND roomID = ${roomID1} `;
}
const createRoom = async (roomID,userID) => 
{
     const datetime = new Date().toISOString().slice(0, 19).replace('T', ' ');
     return sql = "INSERT INTO room (roomID, joinID, status, created_at, updated_at) VALUES ('"+roomID+"','"+userID+"','1','"+datetime+"','"+datetime+"')";
     
    
}
const chatListOnJoin = async (roomID) => 
{
     const roomID1 = mysql.escape(roomID);
     return `SELECT user_chat.*, DATE_FORMAT(user_chat.created_at, '%Y-%m-%d %H:%i:%s') as created_at,DATE_FORMAT(user_chat.updated_at, '%Y-%m-%d %H:%i:%s') as updated_at  FROM user_chat WHERE roomID = ${roomID1}`;
}

const checkUserStatusInRoom = async (request) => 
{
    const roomID1 = mysql.escape(request.roomID);
    return `SELECT * FROM room WHERE roomID = ${roomID1} AND status = '1'`;
};

const SaveMessage = async (request) => 
{
    const senderID1 = mysql.escape(request.senderID);
    const receiverID1 = mysql.escape(request.receiverID);
    const bookingID1 = mysql.escape(request.bookingID);
    const roomID1 = mysql.escape(request.roomID);
    const message1 = mysql.escape(request.message);
    const MessageType1 = mysql.escape(request.MessageType);
    const isAdmin = mysql.escape(request.isAdmin);
    const readstatus = mysql.escape(request.readstatus);
    const datetime = mysql.escape(request.createdTime);
     
    //const datetime1 = new Date().toISOString().slice(0, 19).replace('T', ' ');
    //const datetime = mysql.escape(datetime1);
    
     return sql = `INSERT INTO user_chat (roomID, bookingID, source_user_id, target_user_id, message, status, MessageType,isAdmin, updated_at, created_at) VALUES (${roomID1},${bookingID1},${senderID1},${receiverID1},${message1},${readstatus},${MessageType1},${isAdmin},${datetime},${datetime})`;
};

const SaveBooking = async (request) => 
{
    // console.log(request)
    const bookingID = mysql.escape(request.booking_id);
    const riderID = mysql.escape(request.rider_id);
    const pickupLocation = mysql.escape(request.pickup_location);
    const pickupLat = mysql.escape(request.pickup_lat);
    const pickupLong = mysql.escape(request.pickup_long);
    const dropLocations = mysql.escape(request.drop_locations);
    const pickupDate = mysql.escape(request.pickup_date);
    const pickupTime = mysql.escape(request.pickup_time);
    const carPlateNo = mysql.escape(request.car_plate_no);
    const notes = mysql.escape(request.notes);
    const createdAt = mysql.escape(request.created_at);
   const updatedAt = mysql.escape(request.updated_at);
    //const datetime1 = new Date().toISOString().slice(0, 19).replace('T', ' ');
    //const datetime = mysql.escape(datetime1);
    
    
     return sql = `INSERT INTO bookings (booking_id, rider_id, pickup_location, pickup_lat, pickup_long, pickup_date, pickup_time,car_plate_no, notes, updated_at, created_at) VALUES (${bookingID},${riderID},${pickupLocation},${pickupLat},${pickupLong},${pickupDate},${pickupTime},${carPlateNo},${notes},${createdAt},${updatedAt})`;
};

const SaveDropLocation = async (bookingID, dropLocations) => 
{
     // Validate `dropLocations` as an array
    if (!Array.isArray(dropLocations) || dropLocations.length === 0) {
        throw new Error("Invalid drop locations array");
    }

    // Dynamically set timestamps
    // const createdAt = mysql.escape(new Date().toISOString());
    // const updatedAt = mysql.escape(new Date().toISOString());

    // Prepare queries for each drop location
    const queries = dropLocations.map((location, index) => {
        const dropLocation = mysql.escape(location.drop_location);
        const dropLat = mysql.escape(location.drop_lat);
        const dropLong = mysql.escape(location.drop_long);

        return `INSERT INTO drop_of_points 
            (booking_id, drop_location, drop_lat, drop_long) 
            VALUES (${mysql.escape(bookingID)}, ${dropLocation}, ${dropLat}, ${dropLong})
        `;
    });

    return queries;
};

const getBookingQuery = async (bookingID) => 
{
        const escapedBookingID = mysql.escape(bookingID);
        
        return `
            SELECT 
                b.*,
                JSON_OBJECT(
                    'id', dl.id,
                    'booking_id', dl.booking_id, 
                    'drop_location', dl.drop_location, 
                    'drop_lat', dl.drop_lat, 
                    'drop_long', dl.drop_long,
                    'created_at', dl.created_at,
                    'updated_at', dl.updated_at
                ) AS drop_points
            FROM 
                bookings b
            LEFT JOIN 
                drop_of_points dl 
            ON 
                b.id = dl.booking_id
            WHERE 
                b.id = ${escapedBookingID}
            GROUP BY 
                b.id;
        `;
};

const getBookingDetailByID = async (bookingID) => {
    const escapedBookingID = mysql.escape(bookingID);
    return "SELECT * FROM bookings WHERE id = " + escapedBookingID;
};

const insertNotificationQuery = async (request) => {
    const senderId = request.userID;
    const receiverId = request.otherUserID;
    const bookingId = request.bookingId;
    const title = request.title;
    const message = request.message;
    const type = request.type;
    const datetime = new Date().toISOString().slice(0, 19).replace('T', ' ');
    
    const sql = `
        INSERT INTO notifications 
        (sender_id, receiver_id, booking_id, title, message, type, created_at, updated_at) 
        VALUES (?, ?, ?, ?, ?, ?, ?, ?)
    `;

    // Values to bind to the placeholders
    const values = [senderId, receiverId, bookingId, title, message, type,datetime,datetime];

    return { sql, values };
};



const getMsgList = async (msgID) => 
{
    const msgID1 = mysql.escape(msgID);
    return sql = `select distinct sender.first_name as SenderName, sender.id as senderId,sender.profile_pic as senderProfileImage,
    					receiver.first_name as RecieverName, receiver.id as receiverId, receiver.profile_pic as receiverProfileImage,
    					msg.message,msg.id as msgId,msg.status as readStatus,msg.isAdmin as isAdmin,DATE_FORMAT(msg.created_at, '%Y-%m-%d %H:%i:%s') as created_at,msg.MessageType,msg.roomID,msg.source_user_id,msg.target_user_id
    	from user_chat msg inner join users sender on msg.source_user_id = sender.id
    					  inner join users receiver on msg.target_user_id =receiver.id where msg.id=${msgID1}`;
};



const getrecentChatList = async (request) => 
{
    let user_id = mysql.escape(request.userID);
    return sql = `SELECT main.*, 
    COUNT(CASE WHEN main.readStatus = 0 AND main.receiver_id= ${user_id} THEN 1 END) AS unread_count
    FROM (SELECT DISTINCT sender.first_name as senderName, sender.id as sender_id,sender.profile_pic as sender_profile_picture,
                receiver.first_name as receiverName, receiver.id as receiver_id,receiver.profile_pic as receiver_profile_picture,
                msg.message,DATE_FORMAT(msg.created_at, '%Y-%m-%d %H:%i:%s') as created_at ,msg.status as readStatus,msg.isAdmin as isAdmin,msg.MessageType,msg.bookingID,bookings.pickup_location,
    			(CASE msg.source_user_id > msg.target_user_id
                WHEN true THEN CONCAT(msg.target_user_id, '|', msg.source_user_id)
                WHEN false THEN CONCAT(msg.source_user_id, '|', msg.target_user_id)
            	END) as hash
    			FROM user_chat msg INNER JOIN users sender ON msg.source_user_id = sender.id
                INNER JOIN users receiver ON msg.target_user_id = receiver.id LEFT JOIN bookings ON msg.bookingID=bookings.id
    			WHERE (msg.source_user_id=${user_id} OR msg.target_user_id=${user_id}) ORDER BY msg.created_at DESC) as main 
    			GROUP BY hash ORDER BY created_at DESC`;
};




const UpdateReadStatus = async (request) => 
{
    // console.log(request)
    const senderID = mysql.escape(request.userID);
    const roomID = mysql.escape(request.roomID);
    const receiverID = mysql.escape(request.receiverID);
    
    return sql = `update user_chat SET status=1 where target_user_id=${senderID} AND source_user_id=${receiverID} AND roomID=${roomID}`;
    
};






// Social Crib

const getUserDetailbyIDQuery = async (userID) => 
{
    return sqlQuery = "SELECT  * FROM users  WHERE id ="+ '"'+userID+'"';
    //return sqlQuery = "select c.*,u.firstName,u.lastName,u.userProfile from tbl_cribs as c JOIN tbl_users as u ON u.id = c.userID WHERE c.id = " +cribID;  
}
const getCribDetailByIDQuery = async (request) => 
{
    return sqlQuery = "SELECT tbl_cribs.*, u.firstName, u.lastName, u.userProfile, u.username, IF(s.receiverID = u.id, 1, 0) AS isFollow,IF(s1.senderID = u.id, 1, 0) AS isFollowed,IF(s.receiverID = u.id, 1, 0) AS isFollowBack FROM tbl_cribs JOIN tbl_users AS u ON u.id = tbl_cribs.userID LEFT JOIN tbl_followersAndFollowings AS s ON u.id = s.receiverID AND s.senderID = " + request.userID + " LEFT JOIN tbl_followersAndFollowings AS s1 ON u.id = s1.senderID AND s1.receiverID = " + request.userID + " WHERE tbl_cribs.id = " + request.cribID + " LIMIT 1;";
    //return sqlQuery = "select c.*,u.firstName,u.lastName,u.userProfile from tbl_cribs as c JOIN tbl_users as u ON u.id = c.userID WHERE c.id = " +cribID;  
}
const getCribDetailByuserIDQuery = async (userID) => 
{
    return sqlQuery = "SELECT * FROM tbl_cribs where status = 1 AND userID = " + userID;
    //return sqlQuery = "select c.*,u.firstName,u.lastName,u.userProfile from tbl_cribs as c JOIN tbl_users as u ON u.id = c.userID WHERE c.id = " +cribID;  
}
const getCribDetailByCribIDOnlyQuery = async (request) => 
{
    return sqlQuery = "SELECT  * FROM tbl_cribs  WHERE id = "+ request.cribID;
    //return sqlQuery = "select c.*,u.firstName,u.lastName,u.userProfile from tbl_cribs as c JOIN tbl_users as u ON u.id = c.userID WHERE c.id = " +cribID;  
}

const getCribJoinersQuery = async (request) => 
{
   return sqlQuery = "SELECT tbl_cribJoiners.id as joinerID,u.id as userID,u.firstName,u.lastName,u.userProfile,u.username,tbl_cribJoiners.isAdmin,tbl_cribJoiners.isChatEnabled,tbl_cribJoiners.isHandRaise,tbl_cribJoiners.isUnmute,tbl_cribJoiners.muteByOwner,tbl_cribJoiners.muteByAdmin,IF(s.receiverID = u.id, 1, 0) as isFollow,IF(s1.senderID = u.id, 1, 0) as isFollowed,IF(s.receiverID = u.id, 1, 0) as isFolloweBack,IF(tbl_cribJoiners.joinerID = "+ request.userID +", 1, 0) as isAuthUser FROM tbl_cribJoiners JOIN tbl_users as u ON u.id = tbl_cribJoiners.joinerID LEFT JOIN tbl_followersAndFollowings as s ON u.id = s.receiverID AND s.senderID = "+ request.userID +" LEFT JOIN tbl_followersAndFollowings as s1 ON u.id = s1.senderID AND s1.receiverID = "+ request.userID +" WHERE tbl_cribJoiners.cribID = "+ request.cribID + " AND tbl_cribJoiners.status = 1 AND tbl_cribJoiners.isDeleteByOwner = 0 group by tbl_cribJoiners.id ORDER BY isAuthUser DESC, tbl_cribJoiners.id DESC ";
    /*return sqlQuery = "select u.firstName,u.lastName,u.userProfile,cj.isAdmin from tbl_cribJoiners as cj JOIN tbl_users as u ON u.id = cj.joinerID WHERE cj.cribID = " 
            +cribID+ " order by cj.id desc";*/
}

const blockUserQuery = async (request) => 
{
    return sqlQuery = "INSERT INTO tbl_blockUsers (userID,blockUserID,isBlock,status,created_at) VALUES (?, ?, ?, ?, ?)"; 
}
const alreadyUserBlockedQuery = async (request) => 
{
    return sqlQuery = "SELECT * FROM tbl_blockUsers WHERE userID = " + request.userID + " AND blockUserID = "+ request.blockUserID; 
}
const unblockUserQuery = async (request) => 
{
    return sqlQuery = "DELETE FROM tbl_blockUsers WHERE id = "+request.id; 
}
const endCribQuery = async (request) => 
{
    const datetime = new Date().toISOString().slice(0, 19).replace('T', ' ');
    return sqlQuery = "UPDATE tbl_cribs SET status = 2,updated_at = '" + datetime +  "' WHERE userID = "+request.userID+ " AND id= " + request.cribID;
}
const exitAllCribsIFEndOwnerCribQuery = async (request) => 
{
    const datetime = new Date().toISOString().slice(0, 19).replace('T', ' ');
    return sqlQuery = "UPDATE tbl_cribJoiners SET status = 2,updated_at = '" + datetime +  "' WHERE cribID = " + request.cribID;
}
const exitCribByJoinerQuery = async (request) => 
{
    const datetime = new Date().toISOString().slice(0, 19).replace('T', ' ');
    return sqlQuery = "UPDATE tbl_cribJoiners SET status = 2,updated_at = '" + datetime +  "' WHERE joinerID = "+request.joinerID+ " AND cribID = " + request.cribID;
}
const getCribByJoinerQuery = async (request) => 
{
    return sqlQuery = "SELECT * from tbl_cribJoiners  WHERE joinerID = "+request.joinerID+ " AND cribID = " + request.cribID;
}
const disableChatQuery = async (request) => 
{
    const datetime = new Date().toISOString().slice(0, 19).replace('T', ' ');
    return sqlQuery = "UPDATE tbl_cribs SET isGroupChat = "+request.isChatEnabled+ ",updated_at = '" + datetime +  "' WHERE userID = "+request.userID+ " AND id= " + request.cribID;
    console.log(sqlQuery)
}
const disableChatForAllJoinersQuery = async (request) => 
{
    const datetime = new Date().toISOString().slice(0, 19).replace('T', ' ');
    return sqlQuery = "UPDATE tbl_cribJoiners SET isChatEnabled = 0, updated_at = '" + datetime +  "' WHERE cribID= " + request.cribID;
    console.log(sqlQuery)
}
const disableChatForSelectedJoinersQuery = async (request,joinerID,isChatEnabled) => 
{
    const datetime = new Date().toISOString().slice(0, 19).replace('T', ' ');
    return sqlQuery = "UPDATE tbl_cribJoiners SET isChatEnabled = "+isChatEnabled+ ",updated_at = '" + datetime +  "' WHERE id = "+joinerID+ " AND cribID = " + request.cribID;
}
const totalCountOfNotification = async (request) => 
{
    return sqlQuery = "Select COUNT(*) as total from  tbl_notifications  WHERE receiverID = " +request.userID;
}
const isRaiseHandRequestAlreadySent = async (request) => 
{
    return sqlQuery = "Select * from  tbl_cribJoiners  WHERE isHandRaise = 1 AND joinerID = "+request.userID + " AND cribID = " + request.cribID;
}
const sendRaiseHandRequest = async (request) => 
{
    const datetime = new Date().toISOString().slice(0, 19).replace('T', ' ');
    return sqlQuery = "update  tbl_cribJoiners set isHandRaise = 1 ,updated_at = '" + datetime +  "' WHERE joinerID = "+request.userID + " AND cribID = " + request.cribID;
}
const allRequestToSpeakQuery  = async (request) => 
{
    return  sqlQuery = "SELECT tbl_cribJoiners.cribID,tbl_cribJoiners.id,u.username,u.firstName,u.lastName,u.userProfile,tbl_cribJoiners.isHandRaise,tbl_cribJoiners.isAdmin FROM tbl_cribJoiners JOIN  tbl_users AS u ON u.id = tbl_cribJoiners.joinerID WHERE tbl_cribJoiners.cribID = "+ request.cribID +" AND tbl_cribJoiners.isHandRaise = 1";    
}
const raiseHandRequestAcceptOrRejectQuery  = async (request) => 
{
    const isHandRaise = request.isAccept == 1 ? 2 : 3;
    const datetime = new Date().toISOString().slice(0, 19).replace('T', ' ');
    return sqlQuery = "update  tbl_cribJoiners set isHandRaise = "+ isHandRaise +" ,updated_at = '" + datetime +  "' WHERE id = " + request.id;
}
const setJoinerAdminOrRemoveAdminQuery  = async (request) => 
{
    const datetime = new Date().toISOString().slice(0, 19).replace('T', ' ');
    return sqlQuery = "update  tbl_cribJoiners set isAdmin = "+ request.isAdmin +" ,updated_at = '" + datetime +  "' WHERE id = " + request.id;
}
const getJoinerDetailByID = async (id) => {
    return sqlQuery = "select * from  tbl_cribJoiners WHERE id = " + id;
}

const setMuteOrUnmuteOwnerQuery = async (request) => 
{
    const datetime = new Date().toISOString().slice(0, 19).replace('T', ' ');
    return sqlQuery = "update  tbl_cribs set isUnmute = "+ request.isUnmute +" ,updated_at = '" + datetime +  "' WHERE id = " + request.cribID;
}
const setMuteOrUnmuteAdminQuery = async (request) => 
{
    const datetime = new Date().toISOString().slice(0, 19).replace('T', ' ');
    return sqlQuery = "UPDATE tbl_cribJoiners SET isUnmute = " + request.isUnmute + 
                 ", muteByOwner = " + request.muteByOwner + 
                 ", updated_at = '" + datetime +  
                 "' WHERE id = " + request.id;
}
const setMuteOrUnmuteJoinerQuery = async (request) => 
{
    const datetime = new Date().toISOString().slice(0, 19).replace('T', ' ');
    return sqlQuery = "UPDATE tbl_cribJoiners SET isUnmute = " + request.isUnmute + 
                 ", muteByOwner = " + request.muteByOwner + 
                 ", muteByAdmin = " + request.muteByAdmin + 
                 ", updated_at = '" + datetime +  
                 "' WHERE id = " + request.id;
}

//check if admin already mute by owner then give error

const adminCheckIsMuteByOwnerQuery = async (request,ownerID) => 
{
    return sqlQuery = "select * from tbl_cribJoiners  WHERE id = " + request.id + " AND muteByOwner = " + ownerID + " AND isUnmute = 0";
}
//check if admin already mute by owner then give error

const joinerCheckIsMuteByAdminQuery = async (request) => 
{
    return sqlQuery = "select * from tbl_cribJoiners  WHERE id = " + request.id + " AND isUnmute = 0 AND muteByAdmin IS NOT NULL ";
}

const getListOfCribJoinerAdminQuery = async (request) => 
{
    return sqlQuery = "select joinerID as peopleID FROM tbl_cribJoiners  WHERE isAdmin = 1 AND cribID = " + request.cribID;
}


const isJoinerDeleteByOwnerQuery = async (joinerID,cribID) => 
{
    const cribID1 = mysql.escape(cribID);
    const joinerID1 = mysql.escape(joinerID);
    
    // Construct the SQL query with escaped inputs
    return sql = `UPDATE tbl_cribJoiners SET isDeleteByOwner = 1, status = 2 WHERE cribID = ${cribID1} AND id = ${joinerID1}`;

}


const addFollowAndUnfollowQuery = async (request) => 
{
    const datetime = new Date().toISOString().slice(0, 19).replace('T', ' ');
    const userID = mysql.escape(request.userID);
    const receiverID = mysql.escape(request.receiverID);
    const createdAt = mysql.escape(datetime);
    const updatedAt = mysql.escape(datetime);
    if(request.isFollow == 1)
    {
        return sql = `INSERT INTO tbl_followersAndFollowings (senderID, receiverID, isRequest, status, created_at, updated_at) 
                     VALUES (${userID}, ${receiverID},1, 1, ${createdAt}, ${updatedAt})`;    
    }
    else {
        return sql = `DELETE FROM tbl_followersAndFollowings WHERE senderID = ${userID} AND receiverID = ${receiverID}`;
    
    }
}
const isAlreadyFollow = async (request) => 
{
    
        const userID = mysql.escape(request.userID);
        const receiverID = mysql.escape(request.receiverID);
        return sql = `SELECT * FROM tbl_followersAndFollowings WHERE senderID = ${userID} AND receiverID = ${receiverID}`;
}
/*const setMuteOrUnmuteNormalJoinerQuery = async (request) => 
{
    const datetime = new Date().toISOString().slice(0, 19).replace('T', ' ');
    return sqlQuery = "update tbl_cribJoiners set isUnmute = "+ request.isUnmute +" ,updated_at = '" + datetime +  "' WHERE id = " + request.id;
}*/


/* Start chat flow */

const getRoomIDByUserIDQuery = async (userID) => 
{
    return sqlQuery =  "select * from tbl_room where (userID = "+ '"'+userID+'"' +" or receiverID = "+ '"'+userID+'"' +")";
    //return sqlQuery = "select roomID FROM tbl_room  WHERE userID = " + userID;
}

const getRoomIDByReceiverIDExist = async (userID,roomID) => 
{
    const roomID1 = mysql.escape(roomID);
    return `SELECT * FROM tbl_room WHERE userID = ${mysql.escape(userID)} AND roomID = ${roomID1} LIMIT 1;`;
};


const sendMessageQuery = async (request) => 
{
   
    const datetime = new Date().toISOString().slice(0, 19).replace('T', ' ');
    const roomID = mysql.escape(request.roomID);
    const senderID = mysql.escape(request.senderID);
    const receiverID = mysql.escape(request.receiverID);
    const message = mysql.escape(request.message);
    const createdAt = mysql.escape(request.time);
    const updatedAt = mysql.escape(datetime);
    
    // Construct the SQL query with escaped inputs
    return sql = `INSERT INTO tbl_chat (roomID, senderID, receiverID, message, created_at, updated_at) 
                 VALUES (${roomID}, ${senderID}, ${receiverID}, ${message}, ${createdAt}, ${updatedAt})`;

  //  return sql = "INSERT INTO tbl_chat (roomID,senderID,receiverID,message,created_at,updated_at) VALUES ('"+request.roomID+"','"+request.senderID+"','"+request.receiverID+"','"+request.message+"','"+request.time+"','"+datetime+"')";
}
const getMessageByMessageIDQuery = async (messageID) => 
{
    return sqlQuery = "select *,DATE_FORMAT(created_at, '%Y-%m-%d %H:%i:%s') as created_at FROM tbl_chat  WHERE id = " + messageID;
}
const getMessagesQuery = async (request) => 
{
    /*
    select *,DATE_FORMAT(created_at, '%Y-%m-%d %H:%i:%s') as created_at 
    from 
    tbl_chat 
    where ((receiverID = 12 and senderID = 21) and (deleteBySender != 21 and deleteByReceiver != 21) ) 
    or
    ((receiverID = 21 and senderID = 12) and (deleteBySender != 21 and deleteByReceiver != 21)) 
    
    order by id asc;
    */
    //return sqlQuery =  "select *,DATE_FORMAT(created_at, '%Y-%m-%d %H:%i:%s') as created_at from tbl_chat where (receiverID = "+ '"'+request.receiverID+'"' +" and senderID = "+ '"'+request.senderID+'"' +") or (receiverID = "+ '"'+request.senderID+'"' +" and senderID = "+ '"'+request.receiverID+'"' +") order by id asc";
    return sqlQuery =  "select *,DATE_FORMAT(created_at, '%Y-%m-%d %H:%i:%s') as created_at from tbl_chat where ((receiverID = "+ '"'+request.receiverID+'"' +" and senderID = "+ '"'+request.senderID+'"' +") AND (deleteBySender != "+ '"'+request.senderID+'"' +" and deleteByReceiver != "+ '"'+request.senderID+'"' +")) or ((receiverID = "+ '"'+request.senderID+'"' +" and senderID = "+ '"'+request.receiverID+'"' +") AND (deleteBySender != "+ '"'+request.senderID+'"' +" and deleteByReceiver != "+ '"'+request.senderID+'"' +")) order by id asc";
}

const senderCloseConnectionQuery = async (request) => 
{
    return sqlQuery =  "UPDATE tbl_room set senderStatus = 0 WHERE userID ="+ '"'+request.userID+'"' +" AND roomID="+ '"'+request.roomID+'"';
}

const updateSenderStatusOnCreateRoomByRoomIDQuery = async (roomID) => 
{
    const roomID1 = mysql.escape(roomID);
    return sqlQuery =  `UPDATE tbl_room set senderStatus  = 1 WHERE  roomID = ${roomID1} `;
}
const receiverCloseConnectionQuery = async (request) => 
{
    return sqlQuery =  "UPDATE tbl_room set receiverStatus = 0 WHERE receiverID ="+ '"'+request.userID+'"' +" AND roomID="+ '"'+request.roomID+'"';
}
const updateChatStatusbyuserID = async (request,status) => 
{
    return "UPDATE tbl_chat set status = "+status+" WHERE  userID = "+ '"'+request.userID+'"';    
}
const updateUserStatusbyuserID = async (request,status) => 
{
    return "UPDATE tbl_users set isOnline = "+status+" WHERE  id = "+ '"'+request.userID+'"';    
}
const updateChatOffileStatusbyuserID = async (userID,status) => 
{
    return "UPDATE tbl_chat set status = "+status+" WHERE  userID = "+ '"'+userID+'"';    
}

const getRoomByRoomID = async (roomID) => 
{
    const roomID1 = mysql.escape(roomID);
    return sqlQuery =  `SELECT * FROM tbl_room WHERE roomID = ${roomID1} LIMIT 1;`;
    //return sqlQuery = "select roomID FROM tbl_room  WHERE userID = " + userID;
}
const checkIsFirstMessageOfSender = async (senderID,receiverID) => 
{
    const senderID1 = mysql.escape(senderID);
    const receiverID1 = mysql.escape(receiverID);
    return sqlQuery =  `select count(*) as total from tbl_chat where senderID = ${senderID1} and receiverID = ${receiverID1}`
}
const blockByMeQuery = async (senderID,receiverID) => 
{
    const senderID1 = mysql.escape(senderID);
    const receiverID1 = mysql.escape(receiverID);
    return sqlQuery =  `select * from tbl_blockUsers where userID = ${senderID1} and blockUserID = ${receiverID1}`
}
const blockByHimQuery = async (senderID,receiverID) => 
{
    const senderID1 = mysql.escape(senderID);
    const receiverID1 = mysql.escape(receiverID);
    return sqlQuery =  `select * from tbl_blockUsers where userID = ${receiverID1} and blockUserID = ${senderID1}`
}
const clearChatQuery = async (userID,roomID,fieldName) => 
{
    const userID1 = mysql.escape(userID);
    const roomID1 = mysql.escape(roomID);
    const fieldName1 = mysql.escape(fieldName);
    return sqlQuery =  `Update tbl_chat set ${fieldName} = ${userID1} where roomID = ${roomID1}`
}


const deleteChatQuery = async (roomID) => 
{
    const roomID1 = mysql.escape(roomID);
    return sqlQuery =  `DELETE FROM user_chat where roomID = ${roomID1}`
}




/* Stop Chat flow */

/* start group chat flow */

const getGroupChatRoomByRoomID = async (roomID) => 
{
    const roomID1 = mysql.escape(roomID);
    return sqlQuery =  `SELECT * FROM tbl_cribs WHERE roomID = ${roomID1} LIMIT 1;`;
}
const updateOwnerStatusOnRoomJoinQuery = async (cribID,userID) => 
{
    const cribID1 = mysql.escape(cribID);
    const userID1 = mysql.escape(userID);
    return sqlQuery =  `update tbl_cribs set isRoomJoin = 1 WHERE id = ${cribID1} and userID = ${userID1};`;
}
const updateJoinerStatusOnRoomJoinQuery = async (cribID,userID) => 
{
    const cribID1 = mysql.escape(cribID);
    const userID1 = mysql.escape(userID);
    return sqlQuery =  `update tbl_cribJoiners set isRoomJoin = 1 WHERE cribID = ${cribID1} and joinerID = ${userID1};`;
}

const sendGroupChatMessageQuery = async (request) => 
{
    const datetime = new Date().toISOString().slice(0, 19).replace('T', ' ');
    const roomID = mysql.escape(request.roomID);
    const cribID = mysql.escape(request.cribID);
    const senderID = mysql.escape(request.senderID);
    const receiverID = mysql.escape(request.receiverID);
    const message = mysql.escape(request.message);
    const createdAt = mysql.escape(request.time);
    const updatedAt = mysql.escape(datetime);
    
    // Construct the SQL query with escaped inputs
    return sql = `INSERT INTO tbl_groupChat (roomID, cribID, senderID, receiverID, message, created_at, updated_at) 
                 VALUES (${roomID}, ${cribID}, ${senderID}, ${receiverID}, ${message}, ${createdAt}, ${updatedAt})`;
}
const getGroupChatMessageByMessageIDQuery  = async (messageID) => 
{
    return sqlQuery = "select g.*,u.firstName,u.lastName,u.userProfile,u.username,DATE_FORMAT(g.created_at, '%Y-%m-%d %H:%i:%s') as created_at FROM tbl_groupChat as g left join tbl_users as u on u.id = g.senderID WHERE g.id = " + messageID;
}
const getGroupChatMessagesQuery  = async (cribID,userID) => 
{
    return sqlQuery = `select g.*,u.firstName,u.lastName,u.userProfile,u.username,DATE_FORMAT(g.created_at, '%Y-%m-%d %H:%i:%s') as created_at,IFNULL(b.isBlock, 0) as isBlock,b.id as blockID FROM tbl_groupChat as g left join tbl_users as u on u.id = g.senderID LEFT JOIN (SELECT b1.id,b1.isBlock, b1.blockUserID, b1.userID FROM tbl_blockUsers as b1 WHERE (b1.blockUserID = ${userID} OR b1.userID = ${userID})) as b ON ((b.blockUserID = g.senderID AND b.userID = ${userID}) OR (b.userID = g.senderID AND b.blockUserID = ${userID})) WHERE g.cribID = ${cribID} order by id asc`
    //return sqlQuery = "select g.*,u.firstName,u.lastName,u.userProfile,u.username,DATE_FORMAT(g.created_at, '%Y-%m-%d %H:%i:%s') as created_at FROM tbl_groupChat as g left join tbl_users as u on u.id = g.senderID WHERE g.cribID = " + cribID;
}
const sendRaplyToMessageQuery  = async (request) => 
{
    const datetime = new Date().toISOString().slice(0, 19).replace('T', ' ');
    
    const roomID = mysql.escape(request.roomID);
    const cribID = mysql.escape(request.cribID);
    const senderID = mysql.escape(request.senderID);
    const receiverID = mysql.escape(request.receiverID);
    const messageID = mysql.escape(request.messageID);
    const message = mysql.escape(request.message);
    const createdAt = mysql.escape(request.time);
    const updatedAt = mysql.escape(datetime);
    
    // Construct the SQL query with escaped inputs
    return sql = `INSERT INTO tbl_groupChat (roomID, cribID, senderID, receiverID, message, created_at, updated_at,messageID) 
                 VALUES (${roomID}, ${cribID}, ${senderID}, ${receiverID}, ${message}, ${createdAt}, ${updatedAt}, ${messageID})`;
}
const updateGroupChatMessageQuery = async (request) => 
{
    return sqlQuery = "UPDATE tbl_groupChat SET isEdit = 1,message = '" + request.message +  "', updated_at = '" + request.updated_at +  "' WHERE id= " + request.id;
}
const deleteGroupChatMessageQuery = async (id) => 
{
    return sqlQuery =  `delete from  tbl_groupChat WHERE id = ${id}`;
}
const updateReadStatusForJoinerQuery = async (cribID,senderID) => 
{
    return sqlQuery = `UPDATE tbl_cribJoiners SET isRead = 1  WHERE cribID = ${cribID} AND joinerID != ${senderID}`;
}
const getUnreadStatusQuery = async (request) => 
{
    return sqlQuery =  `SELECT * FROM tbl_cribJoiners WHERE cribID = ${request.cribID} AND joinerID = ${request.userID}`;
}
const updateunReadStatusForJoinerQuery = async (cribID,userID) => 
{
    return sqlQuery = `UPDATE tbl_cribJoiners SET isRead = 0  WHERE cribID = ${cribID} AND joinerID = ${userID}`;
}

const getCribByJoinerByCribIDAndJoinerIDQuery = async (joinerID,cribID) => 
{
    return sqlQuery = "SELECT * from tbl_cribJoiners  WHERE joinerID = "+joinerID+ " AND cribID = " + cribID;
}
const exitCribIfBlockUserIsJoinerQuery = async (id) => 
{
    const datetime = new Date().toISOString().slice(0, 19).replace('T', ' ');
    return sqlQuery = "UPDATE tbl_cribJoiners SET status = 2,updated_at = '" + datetime +  "' WHERE id = " + id;
}
/* stop group chat flow */
module.exports = {
    getCribDetailByIDQuery,
    getCribJoinersQuery,
    blockUserQuery,
    alreadyUserBlockedQuery,
    unblockUserQuery,endCribQuery,exitAllCribsIFEndOwnerCribQuery,
    exitCribByJoinerQuery,disableChatQuery,disableChatForSelectedJoinersQuery,disableChatForAllJoinersQuery,
    getCribByJoinerQuery,totalCountOfNotification,isRaiseHandRequestAlreadySent,
    sendRaiseHandRequest,getCribDetailByCribIDOnlyQuery,getUserDetailbyIDQuery,allRequestToSpeakQuery,
    raiseHandRequestAcceptOrRejectQuery,setJoinerAdminOrRemoveAdminQuery,getJoinerDetailByID,
    setMuteOrUnmuteOwnerQuery,adminCheckIsMuteByOwnerQuery,setMuteOrUnmuteAdminQuery,joinerCheckIsMuteByAdminQuery,
    setMuteOrUnmuteJoinerQuery,
    getListOfCribJoinerAdminQuery,isJoinerDeleteByOwnerQuery,addFollowAndUnfollowQuery,isAlreadyFollow,
    getUserByChatTokenQuery,getRoomIDByUserIDQuery,updateUserStatusOnline,createRoom,checkRoomQuery,sendMessageQuery,
    getMessageByMessageIDQuery,getMessagesQuery,senderCloseConnectionQuery,receiverCloseConnectionQuery,updateChatStatusbyuserID,updateUserStatusbyuserID,getRoomIDByReceiverIDExist,
    getRoomByRoomID,checkIsFirstMessageOfSender,updateRoomStatus,updateSenderStatusOnCreateRoomByRoomIDQuery,blockByMeQuery,blockByHimQuery,clearChatQuery,updateChatOffileStatusbyuserID,
    updateUserOffileStatusbyuserID,updateunReadStatusForJoinerQuery,getGroupChatRoomByRoomID,updateOwnerStatusOnRoomJoinQuery,updateJoinerStatusOnRoomJoinQuery,sendGroupChatMessageQuery,getGroupChatMessageByMessageIDQuery,
    getGroupChatMessagesQuery,sendRaplyToMessageQuery,updateGroupChatMessageQuery,deleteGroupChatMessageQuery,updateReadStatusForJoinerQuery,getUnreadStatusQuery,
    getCribDetailByuserIDQuery,getCribByJoinerByCribIDAndJoinerIDQuery,exitCribIfBlockUserIsJoinerQuery,chatListOnJoin,checkUserStatusInRoom,SaveMessage,SaveBooking,SaveDropLocation,getBookingQuery,getBookingsQuery,getCurrentBookingsQuery,getDriverUpcomingBookingCount,getMsgList,getDropPointsQuery,getrecentChatList,UpdateReadStatus,
    leaveRoomStatus,getUserQuery,updateBookingStatusDriver,updateBookingStatusRider,acceptBookingQuery, getUserDetailByID, getBookingDetailByID, cancelBookingQuery,
    delayBookingQuery,updateUserActivityQuery,insertNotificationQuery ,getDrivers, deleteChatQuery ,rejectBookingQuery
}

/*

owner mute / unmute

admin = mute / unmute (owner can mute/unmute admin ( if owner can mute then admin can't unmute yourself ) )

user = mute / unmute (owner can mute/unmute admin ( if owner can mute then user can't unmute yourself/ if admin can mute then user can't unmute yourself ))


*/
