 
<?php $__env->startSection('title', 'Manage Customers'); ?> 
<?php $__env->startSection('content'); ?> 

<?php if(\Session::get('success')): ?>
<div class="alert alert-success alert-dismissible fade show" role="alert" id="alertSuccess">
    <div class="alert-body">
        <?php echo e(\Session::get('success')); ?>

    </div>
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
<?php endif; ?>
<!-- Page content-->
<div class="container-fluid">
    <div class="content-wrapper" id="dashboard">
        <div class="row">
            <div class="col-12">
                <div class="header">
                    <div class="d-block d-sm-flex align-items-center justify-content-between">
                        <p class="fs-18 mb-0 d-flex align-items-center bg-transparent titlebrown">
                            <span>
                   <svg width="24" height="25" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg">
                <g clip-path="url(#clip0_66_2965)">
                <path opacity="0.2" d="M11.9996 3.20105C10.1789 3.20094 8.40098 3.75304 6.90061 4.78444C5.40024 5.81584 4.24797 7.27805 3.59594 8.97798C2.94392 10.6779 2.82281 12.5356 3.2486 14.3058C3.67439 16.076 4.62706 17.6755 5.98082 18.8929C6.54545 17.7819 7.40664 16.8489 8.46897 16.1973C9.53131 15.5456 10.7533 15.2008 11.9996 15.2011C11.2579 15.2011 10.5329 14.9811 9.91618 14.5691C9.2995 14.157 8.81885 13.5713 8.53502 12.8861C8.25119 12.2009 8.17693 11.4469 8.32162 10.7195C8.46632 9.99203 8.82347 9.32385 9.34792 8.7994C9.87237 8.27495 10.5406 7.9178 11.268 7.77311C11.9954 7.62841 12.7494 7.70267 13.4346 7.9865C14.1199 8.27033 14.7055 8.75098 15.1176 9.36766C15.5296 9.98435 15.7496 10.7094 15.7496 11.4511C15.7496 12.4456 15.3545 13.3994 14.6512 14.1027C13.948 14.806 12.9941 15.2011 11.9996 15.2011C13.2457 15.2007 14.4677 15.5454 15.53 16.1969C16.5923 16.8483 17.4536 17.7811 18.0183 18.892C19.3717 17.6744 20.3241 16.0751 20.7497 14.3051C21.1753 12.535 21.0541 10.6775 20.4021 8.97781C19.7501 7.27809 18.598 5.81604 17.0978 4.78468C15.5977 3.75333 13.82 3.20115 11.9996 3.20105Z" fill="#1C1C1C"/>
                <path d="M12 15.201C14.0711 15.201 15.75 13.5221 15.75 11.451C15.75 9.37998 14.0711 7.70105 12 7.70105C9.92893 7.70105 8.25 9.37998 8.25 11.451C8.25 13.5221 9.92893 15.201 12 15.201Z" stroke="#1C1C1C" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                <path d="M5.98145 18.892C6.54574 17.7805 7.40678 16.847 8.46914 16.1949C9.5315 15.5428 10.7537 15.1976 12.0002 15.1976C13.2467 15.1976 14.4689 15.5428 15.5312 16.1949C16.5936 16.847 17.4547 17.7805 18.0189 18.892" stroke="#1C1C1C" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                <path d="M18.75 12.201L21 14.451L23.25 12.201" stroke="#1C1C1C" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                <path d="M0.75 12.201L3 9.95105L5.25 12.201" stroke="#1C1C1C" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                <path d="M3 9.95105V12.201C2.99929 14.1065 3.60337 15.9631 4.72524 17.5033C5.84712 19.0435 7.42888 20.1879 9.24273 20.7716C11.0566 21.3554 13.0089 21.3484 14.8185 20.7517C16.6282 20.1549 18.2017 18.9992 19.3125 17.451" stroke="#1C1C1C" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                <path d="M21 14.451V12.201C21.0007 10.2956 20.3966 8.43904 19.2748 6.89883C18.1529 5.35862 16.5711 4.21423 14.7573 3.63046C12.9434 3.04669 10.9911 3.05368 9.18147 3.65042C7.37185 4.24716 5.79832 5.40285 4.6875 6.95104" stroke="#1C1C1C" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                </g>
                <defs>
                <clipPath id="clip0_66_2965">
                <rect width="24" height="24" fill="white" transform="translate(0 0.20105)"/>
                </clipPath>
                </defs>
                </svg>
                </span>
                            <span class="mt-1 ms-2">Manage Customers</span>
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <div class="row pt-4">
            <div class="col-lg-12 position-relative">
                <div class="border-0">
                    <div class="card global-shadow p-4 w-100 table-responsive">
                        <table class="isplay w-100" id="upcomingReservation">
                            <thead>
                                <tr>
                                    <th scope="col">Name</th>
                                    <th scope="col">Phone Number</th>
                                    <th scope="col">Email Id</th>
                                    <th scope="col">Recent Active Time</th>
                                    <th scope="col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $coustomers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $coustomer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center me-3">
                                            <div class="avtar_01 me-2">
                                                
                                                <?php if(!empty($coustomer) && !empty($coustomer->profile_pic)): ?>
                                                    <img src="<?php echo e(asset('public/storage/' . $coustomer->profile_pic)); ?>" alt="" class="fir-img">
                                                <?php else: ?>
                                                    <?php
                                                        $firstLetter = strtoupper($coustomer->first_name[0] ?? 'R'); // Default to 'R' if no name is provided
                                                    ?>
                                                    <div style="width: 50px; height: 50px; background-color: #af43f1; color: white; display: flex; justify-content: center; align-items: center; border-radius: 50%; font-size: 20px; font-weight: bold;">
                                                        <?php echo e($firstLetter); ?>

                                                    </div>
                                                <?php endif; ?>


                                                <!--<?php if(!empty($coustomer) && !empty($coustomer->profile_pic)): ?>-->
                                                <!--<img src="<?php echo e(asset('public/storage/' . $coustomer->profile_pic)); ?>" alt="" class="fir-img"> <?php else: ?>-->
                                                <!--<img src="<?php echo e(asset('public/assets/images/users/user-06.png')); ?>" alt="" class="fir-img"> <?php endif; ?>-->
                                            </div>
                                            <div class="">
                                                <p class="mb-0 colorBlack fw-600 lHeight pargh-block-inner"><?php echo e($coustomer->first_name. ' ' .$coustomer->last_name); ?></p>
                                            </div>
                                        </div>
                                    </td>
                                    <td><?php echo e($coustomer->country_code. ' ' .$coustomer->phone); ?></td>
                                    <td><?php echo e($coustomer->email); ?></td>
                                    <td>
                                        <?php if (!empty($coustomer->user_last_active)) { date_default_timezone_set($userTimeZone); echo date( 'jS F Y H:i:s',strtotime($coustomer->user_last_active .' UTC') ); } else{ echo 'N/A'; } ?>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center gap-2">
                                            <!--<button type="button" class="btn btngreen">Activate</button>-->
                                            <?php if($coustomer->status == 1): ?>
                                            <a href="<?php echo e(route('customer.deactivate', $coustomer->id)); ?>" class="btn btn-danger">Deactivate</a> <?php else: ?>
                                            <a href="<?php echo e(route('customer.activate', $coustomer->id)); ?>" class="btn btn-success">Activate</a> <?php endif; ?>
                                            <a class="deleteBtn btn btndark" href="<?php echo e(url('/admin/customers/delete/'.$coustomer->id)); ?>" data-bs-toggle="modal" data-bs-target="#deleteModal">Delete</a>

                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin/layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/phpparastechnolo/public_html/valo/resources/views/admin/customers/index.blade.php ENDPATH**/ ?>