<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <title><?php echo e(config('app.name', 'Valo')); ?></title>
    <link href="<?php echo e(asset('public/assets/css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('public/assets/css/style.css')); ?>">
    <link href="https://fonts.googleapis.com/css2?family=Inter:ital,opsz,wght@0,14..32,100..900;1,14..32,100..900&family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap"
    rel="stylesheet">
</head>

<body>

    <div class="login_wrapper">
        <div class="container-fluid">
            <div class="row">

                <div class="col-xl-6 col-md-6 d-flex align-items-center vh-100 justify-content-center right_form bg-white">
                    <div class="card-shadow w-75">
                        <div class="py-5 px-5 bg-transparent">
                            <div class="text-left pb-4 pt-4">
                                <h1 class="fw-700">Log in</h1>
                                <p class="colorGrayDark fs-16">Welcome back! Please enter your details.</p>
                            </div>
                            <?php if(\Session::get('success')): ?>
                            <div class="alert alert-success alert-dismissible fade show" role="alert" id="alertSuccess">
                                <div class="alert-body">
                                    <?php echo e(\Session::get('success')); ?>

                                </div>
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                            </div>
                            <?php endif; ?> 
                            <?php if(\Session::get('warning')): ?>
                            <div class="alert alert-warning alert-dismissible fade show m-4" role="alert" id="alertWarning">
                                <div class="alert-body">
                                    <?php echo e(\Session::get('warning')); ?>

                                </div>
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                            </div>
                            <?php echo e(\Session::forget('warning')); ?> 
                            <?php endif; ?>
                             <?php if(\Session::get('error')): ?>
                                <div class="alert alert-danger alert-dismissible fade show" role="alert" id="alertError">
                                    <div class="alert-body">
                                        <?php echo e(\Session::get('error')); ?>

                                    </div>
                                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>
                                <?php endif; ?>
                            <form action="<?php echo e(route('adminLoginPost')); ?>" method="POST" id="loginForm">
                                <?php echo csrf_field(); ?>
                                <div class="mb-4 position-relative">
                                    <label class="form-label fs-14">Email Id</label>
                                    <input type="text" name="email" class="form-control customInput" placeholder="Enter Your Email"> 
                                    <?php if($errors->has('email')): ?>
                                    <span class="error text-danger">
                                        <i><?php echo e($errors->first('email')); ?></i>
                                    </span> <?php endif; ?>
                                </div>
                                <div class="mb-3 position-relative">
                                    <label class="form-label fs-14">Password</label>
                                    <input type="password" name="password" class="form-control customInput" id="password" placeholder="Password">
                                    <span id="togglePassword" class="position-absolute" style="cursor: pointer;">
                                        <svg width="24" height="24" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                          <path d="M9.99993 13.6083C8.00827 13.6083 6.3916 11.9916 6.3916 9.99993C6.3916 8.00827 8.00827 6.3916 9.99993 6.3916C11.9916 6.3916 13.6083 8.00827 13.6083 9.99993C13.6083 11.9916 11.9916 13.6083 9.99993 13.6083ZM9.99993 7.6416C8.69993 7.6416 7.6416 8.69993 7.6416 9.99993C7.6416 11.2999 8.69993 12.3583 9.99993 12.3583C11.2999 12.3583 12.3583 11.2999 12.3583 9.99993C12.3583 8.69993 11.2999 7.6416 9.99993 7.6416Z" fill="#C5C0C0"></path>
                                          <path d="M10.0001 17.5165C6.86681 17.5165 3.90848 15.6832 1.87515 12.4998C0.991813 11.1248 0.991813 8.88315 1.87515 7.49982C3.91681 4.31649 6.87515 2.48315 10.0001 2.48315C13.1251 2.48315 16.0835 4.31649 18.1168 7.49982C19.0001 8.87482 19.0001 11.1165 18.1168 12.4998C16.0835 15.6832 13.1251 17.5165 10.0001 17.5165ZM10.0001 3.73315C7.30848 3.73315 4.73348 5.34982 2.93348 8.17482C2.30848 9.14982 2.30848 10.8498 2.93348 11.8248C4.73348 14.6498 7.30848 16.2665 10.0001 16.2665C12.6918 16.2665 15.2668 14.6498 17.0668 11.8248C17.6918 10.8498 17.6918 9.14982 17.0668 8.17482C15.2668 5.34982 12.6918 3.73315 10.0001 3.73315Z" fill="#C5C0C0"></path>
                                        </svg>
                                  </span> 
                                  <?php if($errors->has('password')): ?>
                                    <span class="error text-danger">
                                        <i><?php echo e($errors->first('password')); ?></i>
                                    </span> 
                                    <?php endif; ?>
                                </div>
                                <p class="mb-0 pb-0 text-right w-100 text-end">
                                    <a href="<?php echo e(route('auth.forgotPassword')); ?>" class="w-100 text-decoration-underline">Forgot password?</a>
                                </p>
                               
                                <div class="submit-btn text-center mt-3 mb-2 pb-4">
                                    <button type="submit" class="btn btnRed btn-50 px-5 fw-500 w-100 fs-18 border-0">Login</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="col-xl-6 col-md-6 d-flex align-items-center vh-100 justify-content-center right_side">
                    <div class="logo-block">
                        <img src="<?php echo e(asset('public/assets/images/valo-logo.svg')); ?>" alt="" />
                    </div>
                    <div>
                        <img src="<?php echo e(asset('public/assets/images/car-img.png')); ?>" alt="" width="900px" />
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Bootstrap core JS-->
    <script src="<?php echo e(asset('public/assets/js/bootstrap.bundle.min.js')); ?>"></script>
    <!-- Core theme JS-->
    <script src="<?php echo e(asset('public/assets/js/main.js')); ?>"></script>

    <script>
        var video = document.getElementById("myVideo");
        var btn = document.getElementById("myBtn");
        
        function myFunction() {
          if (video.paused) {
            video.play();
            btn.innerHTML = "Pause";
          } else {
            video.pause();
            btn.innerHTML = "Play";
          }
        }
      
    </script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
           
            setTimeout(function() {
                 var alert = document.getElementById('alertWarning');
                 if (alert) {
                    // Use Bootstrap's alert 'close' method
                     var bsAlert = new bootstrap.Alert(alert);
                     bsAlert.close();
                 }
             }, 3000);
        });
    </script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
           
            setTimeout(function() {
                var alert = document.getElementById('alertError');
                if (alert) {
                    // Use Bootstrap's alert 'close' method
                    var bsAlert = new bootstrap.Alert(alert);
                    bsAlert.close();
                }
            }, 3000);
        });
    </script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
           
            setTimeout(function() {
                var alert = document.getElementById('alertSuccess');
                if (alert) {
                    // Use Bootstrap's alert 'close' method
                    var bsAlert = new bootstrap.Alert(alert);
                    bsAlert.close();
                }
            }, 3000);
        });
    </script>
    <script>
        document.getElementById('togglePassword').addEventListener('click', function () {
            var passwordField = document.getElementById('password');
            var passwordFieldType = passwordField.getAttribute('type');
            
            if (passwordFieldType === 'password') {
              passwordField.setAttribute('type', 'text');
            } else {
              passwordField.setAttribute('type', 'password');
            }
          });
    </script>
</body>

</html><?php /**PATH /home/phpparastechnolo/public_html/valo/resources/views/admin/login.blade.php ENDPATH**/ ?>