 <?php $__env->startSection('title', 'Queries Management'); ?> <?php $__env->startSection('content'); ?> <?php if(\Session::get('success')): ?>
<div class="alert alert-success alert-dismissible fade show" role="alert" id="alertSuccess">
    <div class="alert-body">
        <?php echo e(\Session::get('success')); ?>

    </div>
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
<?php endif; ?>
<!-- Page content-->
<div class="container-fluid">
    <div class="content-wrapper" id="dashboard">
        <div class="row">
            <div class="col-12">
                <div class="header">
                    <div class="d-block d-sm-flex align-items-center justify-content-between">
                        <p class="fs-18 mb-0 d-flex align-items-center bg-transparent titlebrown">
                            <span>
                           <svg xmlns="http://www.w3.org/2000/svg" data-name="Layer 1" viewBox="0 0 32 32" width="24" height="25"><path d="M12,0A12,12,0,1,0,24,12,12.013,12.013,0,0,0,12,0Zm0,22A10,10,0,1,1,22,12,10.011,10.011,0,0,1,12,22Z"/><path d="M12.717,5.063A4,4,0,0,0,8,9a1,1,0,0,0,2,0,2,2,0,0,1,2.371-1.967,2.024,2.024,0,0,1,1.6,1.6,2,2,0,0,1-1.2,2.22A2.916,2.916,0,0,0,11,13.58V14a1,1,0,0,0,2,0v-.42a.938.938,0,0,1,.527-.882,4,4,0,0,0-.81-7.635Z"/><circle cx="12" cy="18" r="1"/></svg>
                        </span>
                            <span class="mt-1 ms-2">Queries Management</span>
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <div class="row pt-4">
            <div class="col-lg-12 position-relative">
                <div class="border-0">
                    <div class="card global-shadow p-4 w-100 table-responsive">
                        <table class="isplay w-100" id="upcomingReservation">
                            <thead>
                                <tr>
                                    <th scope="col">Date</th>
                                    <th scope="col">Name</th>
                                    <th scope="col">Email Id</th>
                                    <th scope="col">Message</th>
                                    <th scope="col">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $queries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $query): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e(\Carbon\Carbon::parse($query->created_at)->format('jS F Y')); ?></td>
                                    <td>
                                        <p class="mb-0 colorBlack fw-600 lHeight pargh-block-inner"><?php echo e($query->name); ?></p>
                                    </td>
                                    <td>
                                        <p class="mb-0 colorBlack fw-600 lHeight"><?php echo e($query->email); ?></p>
                                    </td>
                                    <td>
                                        <?php if(strlen(strip_tags($query->message)) > 40): ?> <?php echo substr(strip_tags($query->message),0,40); ?>

                                        <span><a href="javascript:;" class="queryReadMore" data-subject="<?php echo e($query->subject); ?>" data-message="<?php echo e($query->message); ?>">Read More...</a></span> <?php else: ?> <?php echo substr(strip_tags($query->message),0,40); ?> <?php endif; ?>
                                    </td>
                                    <td>
                                        <a href="#" class="btn btn_vw btnRed px-3 showReplyModel" id="<?php echo e($query->id); ?>" data-bs-target="#replyModal<?php echo e($query->id); ?>" data-model="<?php echo e($query->email); ?>">Reply</a>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Readmore Modal -->
        <div class="modal fade" id="queryView" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="subject"></h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body" id="message">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Reply Modal -->
        <div class="modal fade" id="replyModal" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog">
                <form id="sendMail" method="POST">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Send Message</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                        </div>
                        <div class="modal-body">
                            <input type="hidden" name="email" id="email" value="">
                            <div class="form-group mb-3">
                                <textarea name="message" class="form-control" rows="4" placeholder="Write your reply.."></textarea>
                                <span id="error" class="text-danger"></span>
                                <span id="success" class="text-success"></span>
                            </div>
                            <!-- Loader -->
                            <div id="loader" style="display:none; text-align:center;">
                                <img src="<?php echo e(asset('public/assets/images/loader.gif')); ?>" alt="Loading...">
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                            <button type="submit" class="btn btnRed">Send</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <?php $__env->stopSection(); ?>
<?php echo $__env->make('admin/layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/phpparastechnolo/public_html/valo/resources/views/admin/queries/index.blade.php ENDPATH**/ ?>