<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8" />
    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <title><?php echo e(config('app.name', 'Valo')); ?></title>
    <link rel="icon" type="image/x-icon" href="<?php echo e(asset('public/assets/images/valo-logo.svg')); ?>" />
    <!-- Core theme CSS (includes Bootstrap)-->
    <link href="<?php echo e(asset('public/assets/css/bootstrap.min.css')); ?>" rel="stylesheet" />
    <!-- custom css-->
    <link rel="stylesheet" href="<?php echo e(asset('public/assets/css/style.css')); ?>" />
    <!-- datatable css-->
    <link rel="stylesheet" href="<?php echo e(asset('public/assets/css/jquery.dataTables.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('public/assets/css/dataTables.responsive.css')); ?>">
    <!-- Page-Specific CSS -->
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>

<script>
    var base_url = '<?php echo e(url("/")); ?>/';
        var _token = '<?php echo e(csrf_token()); ?>';
        var queryMngtUrl = "<?php echo e(route('queryMngt')); ?>";
        var faqMngtUrl = "<?php echo e(route('faqMngt')); ?>";
</script>

<body>

    <div id="app">
        <div class="d-flex" id="wrapper">
            <div class="overlay"></div>

            <?php echo $__env->make('admin/layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


            <!-- Page content wrapper-->
            <div id="page-content-wrapper">

                <?php echo $__env->make('admin/layouts.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
                
                <?php echo $__env->yieldContent('content'); ?>


            </div>

        </div>


        <!-- Delete Modal -->
        <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content py-5">
                    <div class="modal-body text-center pt-0">
                        <img src="<?php echo e(asset('public/assets/images/check.png')); ?>" alt="Check Icon" class="img-fluid mb-3">
                        <h5 class="fw-600 text_dark mb-3">Are you sure you want to delete this?</h5>
                        <input type="hidden" id="deleteDriverId" name="driver_id">
                    </div>
                    <div class="d-flex align-items-center justify-content-center gap-3">
                        <button type="button" class="btn btn-danger space-height" data-bs-dismiss="modal">No</button>
                        <a href="#">
                            <button type="button" class="btn btngreen space-height">Yes</button>
                        </a>
                    </div>
                </div>
            </div>
        </div>
        
         

        <!-- Bootstrap core JS-->
        <script src="<?php echo e(asset('public/assets/js/bootstrap.bundle.min.js')); ?>"></script>
        <script src="<?php echo e(asset('public/assets/js/jquery-3.6.1.min.js')); ?>"></script>
        <script src="<?php echo e(asset('public/assets/js/jquery.dataTables.min.js')); ?>"></script>
        <script src="<?php echo e(asset('public/assets/js/dataTables.responsive.js')); ?>"></script>
        <!-- Core theme JS-->
        <script src="<?php echo e(asset('public/assets/js/main.js')); ?>"></script>
        <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
        <script>
            $(document).ready(function () {
                $('#upcomingReservation').dataTable({
                    Response:true,
                    ordering:false,
                    language: {
                        paginate: {
                           next: '<img src="<?php echo e(asset('public/assets/images/next.svg')); ?>">',
                            previous: '<img src="<?php echo e(asset('public/assets/images/prev.svg')); ?>">'
                        }
                    }
                });
            });
        </script>
        <script>
            $(document).ready(function () {
                  $('#upcomingReservation2').dataTable({
                      Response:true,
                      language: {
                          paginate: {
                              next: '<img src="<?php echo e(asset('public/assets/images/next.svg')); ?>">',
                              previous: '<img src="<?php echo e(asset('public/assets/images/prev.svg')); ?>">'
                          }
                      }
                  });
              });
        </script>
        <script>
            const ctx = document.getElementById('myChart');
              new Chart(ctx, {
                type: 'line',
                data: {
                  labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
                  datasets: [{
                    data: [1 , 10, 4, 5, 6, 6, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17,],
                    borderWidth: 3,
                    backgroundColor: [
              'rgba(255, 99, 132, 0.2)',
              'rgba(255, 159, 64, 0.2)',
              'rgba(255, 205, 86, 0.2)',
              'rgba(75, 192, 192, 0.2)',
              'rgba(54, 162, 235, 0.2)',
              'rgba(153, 102, 255, 0.2)',
              'rgba(201, 203, 207, 0.2)'
            ],
            borderColor: [
              'rgb(255, 99, 132)',
              'rgb(255, 159, 64)',
              'rgb(255, 205, 86)',
              'rgb(75, 192, 192)',
              'rgb(54, 162, 235)',
              'rgb(153, 102, 255)',
              'rgb(201, 203, 207)'
            ],
                  }]
                },
                options: {
                  scales: {
                    y: {
                      beginAtZero: true
                    }
                  }
                }
              });
        </script>
        <script>
            const ctx2 = document.getElementById('bar');
               new Chart(ctx2, {
                type: 'bar',
                data: {
                  labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep',  'Oct', 'Nov',' Dec'],
                  datasets: [{
                    label: '# of Votes',
                    data: [100, 80, 60, 40, 20, 3, 50, 60, 70, 50, 11, 100, 80],
                    backgroundColor: ['#89437E'],
                  
                    maxBarThickness:12,
                    borderRadius:10,
                    borderWidth: 1
                  }]
                },
                options: {
                  scales: {
                    y: {
                      beginAtZero: true
                    }
                  }
                }
              });
        </script>
        <script>
            var options1 = {
              type: 'doughnut',
              data: {
                labels: ["Red","Green"],
                datasets: [
            	   {
                            label: '# of Votes',
                            data: [33, 33],
                              barThickness:3,
                            backgroundColor: [
                                'rgba(231, 76, 60, 1)',
                                'rgba(255, 164, 46, 1)',
                                'rgba(46, 204, 113, 1)'
                            ],
                            borderColor: [
                                'rgba(255, 255, 255 ,1)',
                                'rgba(255, 255, 255 ,1)',
                                'rgba(255, 255, 255 ,1)'
                            ],
                            borderWidth:.1
                        }
            		]
              },
              options: {
               rotation: 1 * Math.PI,
                        circumference: 1 * Math.PI,
                        legend: {
                            display: false
                        },
                        tooltip: {
                            enabled: false
                        },
                        cutoutPercentage: 90
              }
            }
            
            var ctx1 = document.getElementById('chartJSContainer').getContext('2d');
            new Chart(ctx1, options1);
        </script>

       <script>
            $('.deleteBtn').click(function(){
               $('#deleteModal').find('a').attr('href', $(this).attr('href'));
            });
        </script>
        <script>
            document.addEventListener('DOMContentLoaded', function() {
               
                setTimeout(function() {
                    var alert = document.getElementById('alertSuccess');
                    if (alert) {
                        // Use Bootstrap's alert 'close' method
                        var bsAlert = new bootstrap.Alert(alert);
                        bsAlert.close();
                    }
                }, 3000);
            });
        </script>
      <script>
        // Wait for the DOM to load
        document.addEventListener('DOMContentLoaded', function() {
            // Get the modal element
            var delayRideModal = document.getElementById('delayRideModal');
            
            // When the modal is shown, set the booking ID in the hidden input
            delayRideModal.addEventListener('show.bs.modal', function(event) {
                // Button that triggered the modal
                var button = event.relatedTarget;
                // Extract info from data-id attribute
                var bookingID = button.getAttribute('data-id');
                // Update the hidden input with the booking ID
                delayRideModal.querySelector('#bookingID').value = bookingID;
            });
        
            // Calculate delay fee based on delay time
            document.getElementById('delayTime').addEventListener('input', function() {
                let delayTime = parseInt(this.value) || 0; // Default to 0 if empty
                const feePerMinute = 0.5; // Fee per minute (adjust as needed)
                let delayFee = delayTime * feePerMinute; // Calculate delay fee
                document.getElementById('delayFee').value = delayFee.toFixed(2); // Set calculated fee
            });
        });
        </script>

<?php echo $__env->yieldContent('js_scripts'); ?>
    
    </div>

</body>

</html><?php /**PATH /home/phpparastechnolo/public_html/valo/resources/views/admin/layouts/app.blade.php ENDPATH**/ ?>