const service = require("../services/mysql.services");



const connectedRoomID = async (socket, io, token) => 
{
    try 
    {
        data = await service.connectedRoomID(token);
    } 
    catch (e) 
    {
        data = e.message;
    }
    return data;
};
const userOnline = async (socket, io, token) => 
{
    try 
    {
        data = await service.userOnline(token);
    } 
    catch (e) 
    {
        data = e.message;
    }
    return data;
};
const userOfflineStatus = async (socket, io, token) => 
{
    try 
    {
        data = await service.userOfflineStatus(token);
    } 
    catch (e) 
    {
        data = e.message;
    }
    return data;
};


const joinRoom = async (socket, io, request) =>
{
    try
    {
         
        data = await service.createOrJoinRoomService(request);
       
        socket.join(request.roomID);
    }
    catch(e)
    {
        data = e.message
    }
    io.to(socket.id).emit("joinRoom",  data);
}

const unjoinRoom = async (socket, io, request) =>
{
    try
    {
        socket.leave(request.roomID);
        data = await service.leaveRoom(request);
        console.log(request.roomID, "RoomID Leave");
    }
    catch(e)
    {
        data = e.message
        console.log(data, "RoomID Leave error")
    }
    
}

const sendMessage = async (socket, io, request, callback) => 
{
    try
    {
        var data = await service.sendMessage(request);
        console.log(data, "data1")
        var recentChat = await service.recentchatList(request);
        console.log(recentChat, "data3")
    }
    catch(e)
    {
        var data = e.message
         console.log(data, "data2")
    }
   
    io.to(request.roomID.toString()).emit('sendMessage', data);
    
    // io.emit('RecentChat', recentChat);
    io.emit('recentChat' + request.receiverID, recentChat);
}

const readMessage = async (socket, io, request, callback) => 
{
    try
    {
        data = await service.readMsg(request);
        console.log(data, "data")
    }
    catch(e)
    {
        data = e.message
         console.log(data, "data")
    }
   
}


const getMessages = async (socket, io, request, callback) => 
{
    try
    {
        data = await service.getMessages(request);
        //console.log(data, "data")
    }
    catch(e)
    {
        data = e.message
    }
    io.to(socket.id).emit('getMessages'+request.token,data);
}

const showTyping = async (socket, io, request, callback) => 
{
    try
    {
        const type='typing';
    }
    catch(e)
    {
        data = e.message
    }
    io.to(request.roomID.toString()).emit('ListenType', type);
    
}


const recentChat = async (socket, io, request, callback) => 
{
    try
    {
        data = await service.recentchatList(request);
        console.log(data, "data")
    }
    catch(e)
    {
        data = e.message
         console.log(data, "data")
    }
   
    io.to(socket.id).emit("RecentChat",  data);
    
    
}
const closeConnection = async (socket, io, request, callback) => 
{
    try
    {
        data = await service.closeConnection(request);
        socket.leave(request.roomID);
        console.log(data, "data")
    }
    catch(e)
    {
        data = e.message
    }
    //io.to(request.roomID).emit('closeConnection');
    io.emit('closeConnection',data);
}
const updateOfflineStatus = async (socket, io, request, callback) => 
{
    try
    {
        data = await service.updateOfflineStatus(request);
        const connectedRooms = await service.userConnectedRooms(request.userID);
        connectedRooms.forEach(room => {
            console.log(room.roomID,'CONNECTED ROOMS')
            io.to(room.roomID).emit('CloseConnectionListner', { isOnline: false, room: room.roomID, userID: request.userID });
        });
       // console.log(data, "data")
    }
    catch(e)
    {
        data = e.message
    }
    //io.to(request.roomID).emit('closeConnection');
    //io.emit('closeConnection',data);
}
const checkOnlineStatus = async (socket, io, request, callback) => 
{
    try
    {
        data = await service.checkOnlineStatus(request);
        console.log(data, "data")
    }
    catch(e)
    {
        console.log(e.message, "DATA ERROR")
        data = e.message
    }
    io.to(request.roomID).emit('CloseConnectionListner',data);
    //io.to(request.roomID).emit('CloseConnectionListner', { isOnline: status, room: request.roomID });
}
const clearChat = async (socket, io, request, callback) => 
{
    try
    {
        data = await service.clearChat(request);
        console.log(data, "data")
    }
    catch(e)
    {
        data = e.message
    }
    io.emit('clearChat',data);
    //io.to(request.roomID).emit('CloseConnectionListner', { isOnline: status, room: request.roomID });
}


const disconnect = async (reason) => 
{
    try
    {
        data = await service.disconnect();
    }
    catch(e)
    {
        data = e.message
    }
    //io.to(request.roomID).emit('closeConnection');
    //io.emit('closeConnection',data);
}

module.exports = {
    connectedRoomID,userOnline,userOfflineStatus,joinRoom,sendMessage,getMessages,closeConnection,checkOnlineStatus,updateOfflineStatus,clearChat,disconnect,recentChat,readMessage,
    unjoinRoom,showTyping
};
