const url = require('url');
const querystring = require('querystring');
//const fetch = require('node-fetch');

const { connectedRoomID,userOnline,userOfflineStatus,createRoom,joinRoom,sendMessage,getMessages,closeConnection,checkOnlineStatus,
updateOfflineStatus,clearChat,disconnect,recentChat,readMessage,unjoinRoom,showTyping} 
= require("./chatController");

const {joinBookingRoom,leaveBookingRoom,scheduleBooking,createdBookingPayment,acceptBooking,updateBookingStatus,joinCurrentBookingsRoom,getBookingDetail,cancelBooking,delayBooking,
        rejectBooking } = require("./bookingController");

const service = require("../services/mysql.services");


const handleSocketEvents = (io) => 
{
    io.on('connection', async (socket) => 
    {
        var query = socket.handshake.query;
        if(query.token)
        {
            try {
                let result;
                const token = query.token;
                console.log(token, "current user");
                console.log("connected");
             //   await service.userOnline(token);
                const user = await userOnline(socket, io, token);
               
               //const user = await userOnline(socket, io, token, callback);
            } catch (error) {
                console.error("Error in connection process:", error);
            }
           
        }
        else
        {
            console.log("connected without token");
        }
        
        socket.on("SendMessage", async (request, callback) => 
        {
            sendMessage(socket, io, request , callback);
        });
        
        socket.on("ReadMessage", async (request, callback) => 
        {
            readMessage(socket, io, request , callback);
        });
        
        socket.on("createBooking", async (request, callback) => 
        {
            scheduleBooking(socket, io, request , callback);
        });
        
        socket.on("createdBookingPaymentSuccess", async (request, callback) => 
        {
            createdBookingPayment(socket, io, request , callback);
        });
        
        socket.on("joinBookingRoomEvent", async (request,callback) => 
        {
            joinBookingRoom(socket,io,request,callback);
        });
        
        socket.on("currentBookingRoomEvent", async (request,callback) => 
        {
            joinCurrentBookingsRoom(socket,io,request,callback);
        });
        
        socket.on("updateBookingStatusEvent", async (request,callback) => 
        {
            updateBookingStatus(socket,io,request,callback);
        });
        
        socket.on("getBookingDetailEvent", async (request,callback) => 
        {
            getBookingDetail(socket,io,request,callback);
        });
        
        socket.on("recentChatEvent", async (request,callback) => 
        {
            recentChat(socket,io,request,callback);
        });
        socket.on("acceptBookingEvent", async (request,callback) => 
        {
            acceptBooking(socket,io,request,callback);
        });
        
        socket.on("cancelBookingEvent", async (request,callback) => 
        {
            cancelBooking(socket,io,request,callback);
        });
        
        socket.on("rejectBookingEvent", async (request,callback) => 
        {
            rejectBooking(socket,io,request,callback);
        });
        
        socket.on("delayBookingEvent", async (request,callback) => 
        {
            delayBooking(socket,io,request,callback);
        });
        
        socket.on("typing", async (request,callback) => 
        {
            showTyping(socket,io,request,callback);
        });
        
          // Event to leave a room
        socket.on('leaveBookingRoomEvent', (request,callback) => {
             leaveBookingRoom(socket,io,request,callback);
        });
        
        socket.on("joinRoomEvent", async (request,callback) => 
        {
            joinRoom(socket,io,request,callback);
        });
         socket.on("unJoinRoom", async (request,callback) => 
        {
            unjoinRoom(socket,io,request,callback);
        });
        
        /* group chat flow stop */
        socket.on('disconnect', async (reason) => {
            console.log(`Socket disconnected: ${reason}`);
            const token = socket.handshake.query.token; 
            try {
                console.log(token,"USER-DISCONNECTED");
                const user = await userOfflineStatus(socket, io, token);
                const connectedRoom = await connectedRoomID(socket, io, token);
                if (connectedRoom && Array.isArray(connectedRoom)) {
                    connectedRoom.forEach(room => {
                        //console.log(room.roomID, 'CONNECTED ROOMS');
                        io.to(room.roomID).emit('CloseConnectionListner', { isOnline: false, room: room.roomID });
                    });
                } else {
                    console.error("No connected rooms found or invalid format.");
                }
            } 
            catch (e) {
                if (e.errno !== 19) {
                    console.log(e.message, "Error");
                }
            }
        });
       
    });
}

module.exports = {
    handleSocketEvents
};